/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi.psd;

import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.DependencyContextExtractor;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;
import edu.ucla.sspace.wordsi.Wordsi;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Map;

public class PseudoWordDependencyContextExtractor
extends DependencyContextExtractor {
    private Map<String, String> pseudoWordMap;

    public PseudoWordDependencyContextExtractor(DependencyExtractor dependencyExtractor, DependencyContextGenerator dependencyContextGenerator, Map<String, String> map) {
        super(dependencyExtractor, dependencyContextGenerator, true);
        this.pseudoWordMap = map;
    }

    @Override
    public void processDocument(BufferedReader bufferedReader, Wordsi wordsi) {
        try {
            String string = this.handleContextHeader(bufferedReader);
            String[] stringArray = string.split("\\s+");
            int n = Integer.parseInt(stringArray[3]);
            DependencyTreeNode[] dependencyTreeNodeArray = this.extractor.readNextTree(bufferedReader);
            if (dependencyTreeNodeArray.length == 0) {
                return;
            }
            DependencyTreeNode dependencyTreeNode = dependencyTreeNodeArray[n];
            String string2 = this.getPrimaryKey(dependencyTreeNode);
            String string3 = this.pseudoWordMap.get(string2);
            if (string3 == null) {
                return;
            }
            if (!this.acceptWord(dependencyTreeNode, stringArray[1], wordsi)) {
                return;
            }
            SparseDoubleVector sparseDoubleVector = this.generator.generateContext(dependencyTreeNodeArray, n);
            wordsi.handleContextVector(string3, string2, sparseDoubleVector);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    protected boolean acceptWord(DependencyTreeNode dependencyTreeNode, String string, Wordsi wordsi) {
        return this.pseudoWordMap.containsKey(dependencyTreeNode.word()) && dependencyTreeNode.word().equals(string);
    }
}

