/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi.psd;

import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.ContextGenerator;
import edu.ucla.sspace.wordsi.Wordsi;
import java.io.BufferedReader;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;

public class PseudoWordContextExtractor
implements ContextExtractor {
    private static final String EMPTY = "";
    private final Map<String, String> pseudoWordMap;
    private final ContextGenerator generator;
    private final int windowSize;

    public PseudoWordContextExtractor(ContextGenerator contextGenerator, int n, Map<String, String> map) {
        this.pseudoWordMap = map;
        this.generator = contextGenerator;
        this.windowSize = n;
    }

    @Override
    public int getVectorLength() {
        return this.generator.getVectorLength();
    }

    @Override
    public void processDocument(BufferedReader bufferedReader, Wordsi wordsi) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque3 = new ArrayDeque<String>();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        for (int i = 0; i < this.windowSize && iterator.hasNext(); ++i) {
            this.addNextToken(iterator.next(), arrayDeque2, arrayDeque3);
        }
        String string = null;
        String string2 = null;
        while (!arrayDeque2.isEmpty()) {
            string = (String)arrayDeque2.remove();
            string2 = (String)arrayDeque3.remove();
            if (iterator.hasNext()) {
                this.addNextToken(iterator.next(), arrayDeque2, arrayDeque3);
            }
            if (!string2.equals(EMPTY)) {
                SparseDoubleVector sparseDoubleVector = this.generator.generateContext(arrayDeque, arrayDeque2);
                wordsi.handleContextVector(string, string2, sparseDoubleVector);
            }
            arrayDeque.offer(string);
            if (arrayDeque.size() <= this.windowSize) continue;
            arrayDeque.remove();
        }
    }

    private void addNextToken(String string, Queue<String> queue, Queue<String> queue2) {
        String string2 = this.pseudoWordMap.get(string);
        if (string2 == null) {
            queue.offer(string);
            queue2.offer(EMPTY);
        } else {
            queue.offer(string2);
            queue2.offer(string);
        }
    }
}

