/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.hal.WeightingFunction;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.ContextGenerator;
import java.util.Queue;

public class WordOccrrenceContextGenerator
implements ContextGenerator {
    private final BasisMapping<String, String> basis;
    private final WeightingFunction weighting;
    private final int windowSize;

    public WordOccrrenceContextGenerator(BasisMapping<String, String> basisMapping, WeightingFunction weightingFunction, int n) {
        this.basis = basisMapping;
        this.weighting = weightingFunction;
        this.windowSize = n;
    }

    @Override
    public SparseDoubleVector generateContext(Queue<String> queue, Queue<String> queue2) {
        CompactSparseVector compactSparseVector = new CompactSparseVector();
        this.addContextTerms(compactSparseVector, queue, -1 * queue.size());
        this.addContextTerms(compactSparseVector, queue2, 1);
        return compactSparseVector;
    }

    @Override
    public int getVectorLength() {
        return this.basis.numDimensions();
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.basis.setReadOnly(bl);
    }

    protected void addContextTerms(SparseDoubleVector sparseDoubleVector, Queue<String> queue, int n) {
        for (String string : queue) {
            int n2;
            if (string.equals("") || (n2 = this.basis.getDimension(string)) == -1) continue;
            sparseDoubleVector.set(n2, this.weighting.weight(n, this.windowSize));
            ++n;
        }
    }
}

