/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.clustering.Assignments;
import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.util.WorkerThread;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.Vectors;
import edu.ucla.sspace.wordsi.AssignmentReporter;
import edu.ucla.sspace.wordsi.BaseWordsi;
import edu.ucla.sspace.wordsi.ContextExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;

public class WaitingWordsi
extends BaseWordsi {
    private static final Logger LOG = Logger.getLogger(WaitingWordsi.class.getName());
    private final Clustering clustering;
    private final Map<String, List<SparseDoubleVector>> dataVectors;
    private final Map<String, SparseDoubleVector> wordSpace;
    private final int numClusters;
    private final AssignmentReporter reporter;

    public WaitingWordsi(Set<String> set, ContextExtractor contextExtractor, Clustering clustering, AssignmentReporter assignmentReporter) {
        this(set, contextExtractor, clustering, assignmentReporter, 0);
    }

    public WaitingWordsi(Set<String> set, ContextExtractor contextExtractor, Clustering clustering, AssignmentReporter assignmentReporter, int n) {
        super(set, contextExtractor);
        this.clustering = clustering;
        this.reporter = assignmentReporter;
        this.numClusters = n;
        this.dataVectors = new HashMap<String, List<SparseDoubleVector>>();
        this.wordSpace = new ConcurrentHashMap<String, SparseDoubleVector>();
    }

    @Override
    public Set<String> getWords() {
        return this.wordSpace.keySet();
    }

    @Override
    public SparseDoubleVector getVector(String string) {
        return this.wordSpace.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleContextVector(String string, String string2, SparseDoubleVector sparseDoubleVector) {
        List<SparseDoubleVector> list = this.dataVectors.get(string);
        if (list == null) {
            WaitingWordsi waitingWordsi = this;
            synchronized (waitingWordsi) {
                list = this.dataVectors.get(string);
                if (list == null) {
                    list = new ArrayList<SparseDoubleVector>();
                    this.dataVectors.put(string, list);
                }
            }
        }
        int n = 0;
        List<SparseDoubleVector> list2 = list;
        synchronized (list2) {
            n = list.size();
            list.add(sparseDoubleVector);
        }
        if (this.reporter != null) {
            this.reporter.assignContextToKey(string, string2, n);
        }
    }

    @Override
    public void processSpace(final Properties properties) {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        int n = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < n; ++i) {
            WorkerThread workerThread = new WorkerThread(linkedBlockingQueue);
            workerThread.start();
        }
        final Semaphore semaphore = new Semaphore(0);
        int n2 = this.dataVectors.size();
        for (Map.Entry<String, List<SparseDoubleVector>> entry : this.dataVectors.entrySet()) {
            final String string = entry.getKey();
            List<SparseDoubleVector> list = entry.getValue();
            final ArrayList<SparseDoubleVector> arrayList = new ArrayList<SparseDoubleVector>(list.size());
            for (SparseDoubleVector sparseDoubleVector : list) {
                arrayList.add(Vectors.subview(sparseDoubleVector, 0, this.getVectorLength()));
            }
            linkedBlockingQueue.offer(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WaitingWordsi.this.clusterTerm(string, arrayList, properties);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        semaphore.release();
                    }
                }
            });
        }
        try {
            semaphore.acquire(n2);
            if (this.reporter != null) {
                this.reporter.finalizeReport();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new Error(interruptedException);
        }
        LOG.info("Finished processing all terms");
    }

    private void clusterTerm(String string, List<SparseDoubleVector> list, Properties properties) {
        SparseMatrix sparseMatrix = Matrices.asSparseMatrix(list);
        LOG.info("Clustering term: " + string);
        Assignments assignments = this.numClusters > 0 ? this.clustering.cluster(sparseMatrix, this.numClusters, properties) : this.clustering.cluster(sparseMatrix, properties);
        LOG.info("Finished clustering term: " + string);
        SparseDoubleVector[] sparseDoubleVectorArray = assignments.getSparseCentroids();
        for (int i = 0; i < sparseDoubleVectorArray.length; ++i) {
            String string2 = i > 0 ? string + "-" + i : string;
            this.wordSpace.put(string2, sparseDoubleVectorArray[i]);
        }
        LOG.info("Finished creating centroids for term: " + string);
        if (this.reporter == null) {
            return;
        }
        String[] stringArray = this.reporter.contextLabels(string);
        if (stringArray.length == 0) {
            return;
        }
        LOG.info("Making assignment report: " + string);
        for (int i = 0; i < assignments.size(); ++i) {
            if (assignments.get(i).assignments().length <= 0) continue;
            this.reporter.updateAssignment(string, stringArray[i], assignments.get(i).assignments()[0]);
        }
        LOG.info("Finished making assignment report: " + string);
    }
}

