/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.Wordsi;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;

public class TopicModelContextExtractor
implements ContextExtractor {
    private int vectorLength;

    @Override
    public void processDocument(BufferedReader bufferedReader, Wordsi wordsi) {
        try {
            String string = bufferedReader.readLine();
            if (string == null) {
                return;
            }
            String[] stringArray = string.split("\\s+");
            String[] stringArray2 = stringArray[0].split("\\.");
            if (stringArray.length < 10) {
                return;
            }
            this.vectorLength = (stringArray.length - 1) / 2;
            CompactSparseVector compactSparseVector = new CompactSparseVector((stringArray.length - 1) / 2);
            for (int i = 1; i < stringArray.length; i += 2) {
                int n = Integer.parseInt(stringArray[i]);
                double d = Double.parseDouble(stringArray[i + 1]);
                compactSparseVector.set(n, d);
            }
            wordsi.handleContextVector(stringArray2[0], stringArray[0], compactSparseVector);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }
}

