/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.clustering.Cluster;
import edu.ucla.sspace.clustering.HierarchicalAgglomerativeClustering;
import edu.ucla.sspace.clustering.OnlineClustering;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.util.Generator;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.AssignmentReporter;
import edu.ucla.sspace.wordsi.BaseWordsi;
import edu.ucla.sspace.wordsi.ContextExtractor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class StreamingWordsi
extends BaseWordsi {
    private GeneratorMap<OnlineClustering<SparseDoubleVector>> clusterMap;
    private final Map<String, SparseDoubleVector> wordSpace;
    private final AssignmentReporter reporter;
    private final int numClusters;

    public StreamingWordsi(Set<String> set, ContextExtractor contextExtractor, Generator<OnlineClustering<SparseDoubleVector>> generator, AssignmentReporter assignmentReporter, int n) {
        super(set, contextExtractor);
        this.clusterMap = new GeneratorMap<OnlineClustering<SparseDoubleVector>>(generator);
        this.reporter = assignmentReporter;
        this.numClusters = n;
        this.wordSpace = new HashMap<String, SparseDoubleVector>();
    }

    @Override
    public Set<String> getWords() {
        return this.wordSpace.keySet();
    }

    @Override
    public SparseDoubleVector getVector(String string) {
        return this.wordSpace.get(string);
    }

    @Override
    public void handleContextVector(String string, String string2, SparseDoubleVector sparseDoubleVector) {
        OnlineClustering<SparseDoubleVector> onlineClustering = this.clusterMap.get(string);
        int n = onlineClustering.addVector(sparseDoubleVector);
        if (this.reporter != null) {
            this.reporter.assignContextToKey(string, string2, n);
        }
    }

    @Override
    public void processSpace(Properties properties) {
        double d = 0.15;
        for (Map.Entry<String, OnlineClustering<SparseDoubleVector>> entry : this.clusterMap.entrySet()) {
            String[] stringArray;
            List<Cluster<SparseDoubleVector>> list = this.clusterStream(entry.getValue().getClusters(), this.numClusters, 0.0);
            list = this.clusterStream(entry.getValue().getClusters(), 0, d);
            String string = entry.getKey();
            this.wordSpace.put(string, list.get(0).centroid());
            for (int i = 1; i < list.size(); ++i) {
                this.wordSpace.put(string + "-" + i, list.get(i).centroid());
            }
            if (this.reporter == null || (stringArray = this.reporter.contextLabels(string)).length == 0) continue;
            int n = 0;
            for (Cluster<SparseDoubleVector> cluster : list) {
                BitSet bitSet = cluster.dataPointIds();
                int n2 = bitSet.nextSetBit(0);
                while (n2 >= 0) {
                    this.reporter.updateAssignment(string, stringArray[n2], n);
                    n2 = bitSet.nextSetBit(n2 + 1);
                }
                ++n;
            }
        }
        this.clusterMap = null;
        if (this.reporter != null) {
            this.reporter.finalizeReport();
        }
    }

    private List<Cluster<SparseDoubleVector>> clusterStream(List<Cluster<SparseDoubleVector>> list, int n, double d) {
        ArrayList<SparseDoubleVector> arrayList = new ArrayList<SparseDoubleVector>();
        for (Cluster<SparseDoubleVector> object2 : list) {
            arrayList.add(object2.centroid());
        }
        Object object3 = n != 0 ? (Object)HierarchicalAgglomerativeClustering.partitionRows(Matrices.asSparseMatrix(arrayList), n, HierarchicalAgglomerativeClustering.ClusterLinkage.MEAN_LINKAGE, Similarity.SimType.COSINE) : (Object)HierarchicalAgglomerativeClustering.clusterRows(Matrices.asSparseMatrix(arrayList), d, HierarchicalAgglomerativeClustering.ClusterLinkage.MEAN_LINKAGE, Similarity.SimType.COSINE);
        ArrayList<Cluster<SparseDoubleVector>> arrayList2 = new ArrayList<Cluster<SparseDoubleVector>>();
        for (int i = 0; i < ((Object)object3).length; ++i) {
            Object object = object3[i];
            while (object >= arrayList2.size()) {
                arrayList2.add(null);
            }
            Cluster cluster = (Cluster)arrayList2.get((int)object);
            if (cluster == null) {
                arrayList2.set((int)object, list.get(i));
                continue;
            }
            cluster.merge(list.get(i));
        }
        return arrayList2;
    }
}

