/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.FilteredDependencyIterator;
import edu.ucla.sspace.dependency.UniversalPathAcceptor;
import edu.ucla.sspace.svs.StructuredVectorSpace;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.VectorMath;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;

public class SelPrefDependencyContextGenerator
implements DependencyContextGenerator {
    public static final String EMPTY_STRING = "";
    private final StructuredVectorSpace svs;
    private final DependencyPathAcceptor acceptor;

    public SelPrefDependencyContextGenerator(StructuredVectorSpace structuredVectorSpace) {
        this.svs = structuredVectorSpace;
        this.acceptor = new UniversalPathAcceptor();
    }

    @Override
    public SparseDoubleVector generateContext(DependencyTreeNode[] dependencyTreeNodeArray, int n) {
        FilteredDependencyIterator filteredDependencyIterator = new FilteredDependencyIterator(dependencyTreeNodeArray[n], this.acceptor, 1);
        if (!filteredDependencyIterator.hasNext()) {
            return new CompactSparseVector();
        }
        SparseDoubleVector sparseDoubleVector = this.contextualize((DependencyPath)filteredDependencyIterator.next());
        if (!filteredDependencyIterator.hasNext()) {
            return sparseDoubleVector;
        }
        SparseDoubleVector sparseDoubleVector2 = this.contextualize((DependencyPath)filteredDependencyIterator.next());
        return VectorMath.multiplyUnmodified(sparseDoubleVector, sparseDoubleVector2);
    }

    private SparseDoubleVector contextualize(DependencyPath dependencyPath) {
        DependencyRelation dependencyRelation = dependencyPath.iterator().next();
        String string = dependencyRelation.relation();
        String string2 = dependencyPath.first().word();
        String string3 = dependencyPath.last().word();
        if (string3.equals(EMPTY_STRING)) {
            return null;
        }
        boolean bl = !dependencyRelation.headNode().word().equals(string2);
        return this.svs.contextualize(string2, string, string3, bl);
    }

    @Override
    public void setReadOnly(boolean bl) {
    }

    @Override
    public int getVectorLength() {
        return this.svs.getVectorLength();
    }
}

