/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyPermutationFunction;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.FilteredDependencyIterator;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;
import java.util.Map;

public class RandomIndexingDependencyContextGenerator
implements DependencyContextGenerator {
    private final DependencyPermutationFunction<TernaryVector> permFunc;
    private final Map<String, TernaryVector> indexMap;
    private final int indexVectorLength;
    private final int pathLength;
    private final DependencyPathAcceptor acceptor;
    private boolean readOnly;

    public RandomIndexingDependencyContextGenerator(DependencyPermutationFunction<TernaryVector> dependencyPermutationFunction, DependencyPathAcceptor dependencyPathAcceptor, Map<String, TernaryVector> map, int n, int n2) {
        this.permFunc = dependencyPermutationFunction;
        this.acceptor = dependencyPathAcceptor;
        this.indexMap = map;
        this.indexVectorLength = n;
        this.pathLength = n2;
    }

    @Override
    public SparseDoubleVector generateContext(DependencyTreeNode[] dependencyTreeNodeArray, int n) {
        DependencyTreeNode dependencyTreeNode = dependencyTreeNodeArray[n];
        CompactSparseVector compactSparseVector = new CompactSparseVector(this.indexVectorLength);
        FilteredDependencyIterator filteredDependencyIterator = new FilteredDependencyIterator(dependencyTreeNode, this.acceptor, this.pathLength);
        while (filteredDependencyIterator.hasNext()) {
            DependencyPath dependencyPath = (DependencyPath)filteredDependencyIterator.next();
            if (this.readOnly && !this.indexMap.containsKey(dependencyPath.last().word())) continue;
            TernaryVector ternaryVector = this.indexMap.get(dependencyPath.last().word());
            if (this.permFunc != null) {
                ternaryVector = this.permFunc.permute(ternaryVector, dependencyPath);
            }
            this.add(compactSparseVector, ternaryVector);
        }
        return compactSparseVector;
    }

    @Override
    public int getVectorLength() {
        return this.indexVectorLength;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    private void add(SparseDoubleVector sparseDoubleVector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            sparseDoubleVector.add(n, 1.0);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            sparseDoubleVector.add(n, -1.0);
        }
    }
}

