/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.wordsi.ContextGenerator;
import java.util.Map;
import java.util.Queue;

public class RandomIndexingContextGenerator
implements ContextGenerator {
    private final Map<String, TernaryVector> indexMap;
    private final PermutationFunction<TernaryVector> permFunc;
    private final int indexVectorLength;
    private boolean readOnly;

    public RandomIndexingContextGenerator(Map<String, TernaryVector> map, PermutationFunction<TernaryVector> permutationFunction, int n) {
        this.indexMap = map;
        this.permFunc = permutationFunction;
        this.indexVectorLength = n;
    }

    @Override
    public SparseDoubleVector generateContext(Queue<String> queue, Queue<String> queue2) {
        CompactSparseVector compactSparseVector = new CompactSparseVector(this.indexVectorLength);
        this.addContextTerms(compactSparseVector, queue, -1 * queue.size());
        this.addContextTerms(compactSparseVector, queue2, 1);
        return compactSparseVector;
    }

    @Override
    public int getVectorLength() {
        return this.indexVectorLength;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    protected void addContextTerms(SparseDoubleVector sparseDoubleVector, Queue<String> queue, int n) {
        for (String string : queue) {
            TernaryVector ternaryVector;
            if (string.equals("") || this.readOnly && !this.indexMap.containsKey(string) || (ternaryVector = this.indexMap.get(string)) == null) continue;
            if (this.permFunc != null) {
                ternaryVector = this.permFunc.permute(ternaryVector, n);
            }
            this.add(sparseDoubleVector, ternaryVector);
            ++n;
        }
    }

    private void add(SparseDoubleVector sparseDoubleVector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            sparseDoubleVector.add(n, 1.0);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            sparseDoubleVector.add(n, -1.0);
        }
    }
}

