/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.ContextGenerator;
import edu.ucla.sspace.wordsi.Wordsi;
import java.io.BufferedReader;
import java.util.ArrayDeque;
import java.util.Iterator;

public class GeneralContextExtractor
implements ContextExtractor {
    private final ContextGenerator generator;
    private final int windowSize;
    private final boolean readHeader;

    public GeneralContextExtractor(ContextGenerator contextGenerator, int n, boolean bl) {
        this.generator = contextGenerator;
        this.windowSize = n;
        this.readHeader = bl;
    }

    @Override
    public int getVectorLength() {
        return this.generator.getVectorLength();
    }

    @Override
    public void processDocument(BufferedReader bufferedReader, Wordsi wordsi) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        if (!iterator.hasNext()) {
            return;
        }
        String string = null;
        if (this.readHeader) {
            string = iterator.next();
        }
        for (int i = 0; i < this.windowSize && iterator.hasNext(); ++i) {
            arrayDeque2.offer(iterator.next());
        }
        String string2 = null;
        while (!arrayDeque2.isEmpty()) {
            String string3;
            string2 = (String)arrayDeque2.remove();
            String string4 = string3 = string == null ? string2 : string;
            if (iterator.hasNext()) {
                arrayDeque2.offer(iterator.next());
            }
            if (wordsi.acceptWord(string2)) {
                SparseDoubleVector sparseDoubleVector = this.generator.generateContext(arrayDeque, arrayDeque2);
                wordsi.handleContextVector(string2, string3, sparseDoubleVector);
            }
            arrayDeque.offer(string2);
            if (arrayDeque.size() <= this.windowSize) continue;
            arrayDeque.remove();
        }
    }
}

