/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.wordsi.AssignmentReporter;
import edu.ucla.sspace.wordsi.BaseWordsi;
import edu.ucla.sspace.wordsi.ContextExtractor;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class EvaluationWordsi
extends BaseWordsi {
    private final SemanticSpace wordSpace;
    private final AssignmentReporter reporter;

    public EvaluationWordsi(Set<String> set, ContextExtractor contextExtractor, SemanticSpace semanticSpace, AssignmentReporter assignmentReporter) {
        super(set, contextExtractor);
        this.wordSpace = semanticSpace;
        this.reporter = assignmentReporter;
    }

    @Override
    public Set<String> getWords() {
        return new HashSet<String>();
    }

    @Override
    public Vector getVector(String string) {
        return this.wordSpace.getVector(string);
    }

    @Override
    public void handleContextVector(String string, String string2, SparseDoubleVector sparseDoubleVector) {
        Vector vector;
        int n = 0;
        int n2 = 0;
        double d = -1.0;
        while ((vector = this.getVector(n == 0 ? string : string + "-" + n)) != null) {
            double d2 = Similarity.cosineSimilarity(vector, (Vector)sparseDoubleVector);
            if (d2 > d) {
                d = d2;
                n2 = n;
            }
            ++n;
        }
        if (this.reporter != null) {
            this.reporter.updateAssignment(string, string2, n2);
        }
    }

    @Override
    public void processSpace(Properties properties) {
        if (this.reporter != null) {
            this.reporter.finalizeReport();
        }
    }
}

