/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;
import edu.ucla.sspace.wordsi.Wordsi;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;

public class DependencyContextExtractor
implements ContextExtractor {
    protected final DependencyExtractor extractor;
    protected final DependencyContextGenerator generator;
    protected final boolean readHeader;

    public DependencyContextExtractor(DependencyExtractor dependencyExtractor, DependencyContextGenerator dependencyContextGenerator) {
        this(dependencyExtractor, dependencyContextGenerator, false);
    }

    public DependencyContextExtractor(DependencyExtractor dependencyExtractor, DependencyContextGenerator dependencyContextGenerator, boolean bl) {
        this.extractor = dependencyExtractor;
        this.generator = dependencyContextGenerator;
        this.readHeader = bl;
    }

    @Override
    public int getVectorLength() {
        return this.generator.getVectorLength();
    }

    @Override
    public void processDocument(BufferedReader bufferedReader, Wordsi wordsi) {
        try {
            String string = this.handleContextHeader(bufferedReader);
            DependencyTreeNode[] dependencyTreeNodeArray = this.extractor.readNextTree(bufferedReader);
            if (dependencyTreeNodeArray.length == 0) {
                return;
            }
            for (int i = 0; i < dependencyTreeNodeArray.length; ++i) {
                DependencyTreeNode dependencyTreeNode = dependencyTreeNodeArray[i];
                String string2 = this.getPrimaryKey(dependencyTreeNode);
                String string3 = this.getSecondaryKey(dependencyTreeNode, string);
                if (!this.acceptWord(dependencyTreeNode, string, wordsi)) continue;
                SparseDoubleVector sparseDoubleVector = this.generator.generateContext(dependencyTreeNodeArray, i);
                wordsi.handleContextVector(string2, string3, sparseDoubleVector);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    protected boolean acceptWord(DependencyTreeNode dependencyTreeNode, String string, Wordsi wordsi) {
        return wordsi.acceptWord(dependencyTreeNode.word());
    }

    protected String getPrimaryKey(DependencyTreeNode dependencyTreeNode) {
        return dependencyTreeNode.word();
    }

    protected String getSecondaryKey(DependencyTreeNode dependencyTreeNode, String string) {
        return string == null ? dependencyTreeNode.word() : string;
    }

    protected String handleContextHeader(BufferedReader bufferedReader) throws IOException {
        return this.readHeader ? bufferedReader.readLine().trim() : null;
    }
}

