/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;
import java.util.ArrayDeque;
import java.util.Queue;

public abstract class AbstractOccurrenceDependencyContextGenerator
implements DependencyContextGenerator {
    private final BasisMapping<String, String> basis;
    private final int windowSize;

    public AbstractOccurrenceDependencyContextGenerator(BasisMapping<String, String> basisMapping, int n) {
        this.basis = basisMapping;
        this.windowSize = n;
    }

    @Override
    public SparseDoubleVector generateContext(DependencyTreeNode[] dependencyTreeNodeArray, int n) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        for (int i = Math.max(0, n - this.windowSize - 1); i < n; ++i) {
            arrayDeque.add(this.getFeature(dependencyTreeNodeArray[i], i - n));
        }
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        for (int i = n + 1; i < Math.min(n + this.windowSize + 1, dependencyTreeNodeArray.length); ++i) {
            arrayDeque2.add(this.getFeature(dependencyTreeNodeArray[i], i - n));
        }
        CompactSparseVector compactSparseVector = new CompactSparseVector();
        this.addContextTerms(compactSparseVector, arrayDeque, -1 * arrayDeque.size());
        this.addContextTerms(compactSparseVector, arrayDeque2, 1);
        return compactSparseVector;
    }

    protected abstract String getFeature(DependencyTreeNode var1, int var2);

    protected void addContextTerms(SparseDoubleVector sparseDoubleVector, Queue<String> queue, int n) {
        for (String string : queue) {
            int n2;
            if (string.equals("") || (n2 = this.basis.getDimension(string)) == -1) continue;
            sparseDoubleVector.set(n2, 1.0);
            ++n;
        }
    }

    @Override
    public int getVectorLength() {
        return this.basis.numDimensions();
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.basis.setReadOnly(bl);
    }
}

