/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.DoubleEntry;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.DoubleVectorView;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseVector;

class ViewDoubleAsDoubleSparseVector
extends DoubleVectorView
implements SparseDoubleVector {
    private static final long serialVersionUID = 1L;
    private final SparseVector sparseVector;

    public <T extends DoubleVector & SparseVector<Double>> ViewDoubleAsDoubleSparseVector(T t) {
        this(t, 0, t.length(), false);
    }

    public <T extends DoubleVector & SparseVector<Double>> ViewDoubleAsDoubleSparseVector(T t, boolean bl) {
        this(t, 0, t.length(), bl);
    }

    public <T extends DoubleVector & SparseVector<Double>> ViewDoubleAsDoubleSparseVector(T t, int n, int n2) {
        this(t, n, n2, false);
    }

    public <T extends DoubleVector & SparseVector<Double>> ViewDoubleAsDoubleSparseVector(T t, int n, int n2, boolean bl) {
        super(t, n, n2, bl);
        this.sparseVector = t;
    }

    @Override
    public int[] getNonZeroIndices() {
        int[] nArray;
        if (this.vectorOffset == 0 && this.vectorLength == this.sparseVector.length()) {
            return this.sparseVector.getNonZeroIndices();
        }
        int n = 0;
        for (int n2 : nArray = this.sparseVector.getNonZeroIndices()) {
            if (n2 < this.vectorOffset || n2 >= this.vectorOffset + this.vectorLength) continue;
            ++n;
        }
        int[] nArray2 = new int[n];
        int n3 = 0;
        for (int n4 : nArray) {
            if (n4 < this.vectorOffset || n4 >= this.vectorOffset + this.vectorLength) continue;
            nArray2[n3++] = n4;
        }
        return nArray2;
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            if (this.sparseVector instanceof Iterable) {
                for (DoubleEntry doubleEntry : (Iterable)((Object)this.sparseVector)) {
                    int n = doubleEntry.index();
                    if (n < this.vectorOffset || n >= this.vectorOffset + this.vectorLength) continue;
                    double d2 = doubleEntry.value();
                    d += d2 * d2;
                }
            } else {
                for (int n : this.sparseVector.getNonZeroIndices()) {
                    if (n < this.vectorOffset || n >= this.vectorOffset + this.vectorLength) continue;
                    double d3 = this.doubleVector.get(n);
                    d += d3 * d3;
                }
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }
}

