/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.Vector;
import java.io.Serializable;

class VectorView<T extends Number>
implements Vector<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final boolean isImmutable;
    protected final Vector vector;
    protected final int vectorLength;
    protected final int vectorOffset;
    protected double magnitude;

    public VectorView(Vector vector) {
        this(vector, 0, vector.length(), false);
    }

    public VectorView(Vector vector, boolean bl) {
        this(vector, 0, vector.length(), bl);
    }

    public VectorView(Vector vector, int n, int n2) {
        this(vector, 0, vector.length(), false);
    }

    public VectorView(Vector vector, int n, int n2, boolean bl) {
        if (vector == null) {
            throw new NullPointerException("Cannot create a view of a null vector");
        }
        this.vector = vector;
        this.vectorOffset = n;
        this.vectorLength = n2;
        this.isImmutable = bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot have negative length");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Offset cannot be negative");
        }
        if (n + n2 > vector.length()) {
            throw new IllegalArgumentException("Cannot create view larger than vector");
        }
        this.magnitude = -1.0;
    }

    @Override
    public void set(int n, Number number) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        this.vector.set(this.getIndex(n), number);
        this.magnitude = -1.0;
    }

    protected int getIndex(int n) {
        if (n < 0 || n > this.vectorLength) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        return n + this.vectorOffset;
    }

    @Override
    public Number getValue(int n) {
        return this.vector.getValue(this.getIndex(n));
    }

    @Override
    public int length() {
        return this.vectorLength;
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            for (int i = this.vectorOffset; i < this.vectorOffset + this.vectorLength; ++i) {
                Number number = this.vector.getValue(i);
                d += number.doubleValue() * number.doubleValue();
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }

    public String toString() {
        return this.vector.toString();
    }
}

