/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.IntegerEntry;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.IntegerVectorView;
import edu.ucla.sspace.vector.SparseIntegerVector;
import edu.ucla.sspace.vector.SparseVector;

class SparseIntegerVectorView
extends IntegerVectorView
implements SparseIntegerVector {
    private static final long serialVersionUID = 1L;
    private final SparseVector sparseVector;

    public <T extends IntegerVector & SparseVector<Integer>> SparseIntegerVectorView(T t) {
        this(t, 0, t.length(), false);
    }

    public <T extends IntegerVector & SparseVector<Integer>> SparseIntegerVectorView(T t, boolean bl) {
        this(t, 0, t.length(), bl);
    }

    public <T extends IntegerVector & SparseVector<Integer>> SparseIntegerVectorView(T t, int n, int n2) {
        this(t, n, n2, false);
    }

    public <T extends IntegerVector & SparseVector<Integer>> SparseIntegerVectorView(T t, int n, int n2, boolean bl) {
        super(t, n, n2, bl);
        this.sparseVector = t;
    }

    @Override
    public int[] getNonZeroIndices() {
        int[] nArray;
        if (this.vectorOffset == 0 && this.vectorLength == this.sparseVector.length()) {
            return this.sparseVector.getNonZeroIndices();
        }
        int n = 0;
        for (int n2 : nArray = this.sparseVector.getNonZeroIndices()) {
            if (n2 < this.vectorOffset || n2 >= this.vectorOffset + this.vectorLength) continue;
            ++n;
        }
        int[] nArray2 = new int[n];
        int n3 = 0;
        for (int n4 : nArray) {
            if (n4 < this.vectorOffset || n4 >= this.vectorOffset + this.vectorLength) continue;
            nArray2[n3++] = n4;
        }
        return nArray2;
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            if (this.sparseVector instanceof Iterable) {
                for (IntegerEntry integerEntry : (Iterable)((Object)this.sparseVector)) {
                    int n = integerEntry.index();
                    if (n < this.vectorOffset || n >= this.vectorOffset + this.vectorLength) continue;
                    int n2 = integerEntry.value();
                    d += (double)(n2 * n2);
                }
            } else {
                for (int n : this.sparseVector.getNonZeroIndices()) {
                    if (n < this.vectorOffset || n >= this.vectorOffset + this.vectorLength) continue;
                    int n3 = this.intVector.get(n);
                    d += (double)(n3 * n3);
                }
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }
}

