/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.SparseHashArray;
import edu.ucla.sspace.vector.SparseVector;
import java.io.Serializable;

public class SparseHashVector<T extends Number>
implements SparseVector<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected SparseHashArray<Number> vector;
    protected double magnitude;

    public SparseHashVector(int n) {
        this.vector = new SparseHashArray(n);
        this.magnitude = -1.0;
    }

    public SparseHashVector(T[] TArray) {
        this.vector = new SparseHashArray<T>(TArray);
        this.magnitude = -1.0;
    }

    @Override
    public int[] getNonZeroIndices() {
        return this.vector.getElementIndices();
    }

    @Override
    public Number getValue(int n) {
        Number number = this.vector.get(n);
        return number == null ? (Number)0 : (Number)number;
    }

    @Override
    public int length() {
        return this.vector.length();
    }

    @Override
    public double magnitude() {
        System.out.println(this.magnitude);
        if (this.magnitude < 0.0) {
            System.out.println("mag");
            this.magnitude = 0.0;
            for (int n : this.getNonZeroIndices()) {
                double d = this.vector.get(n).doubleValue();
                this.magnitude += d * d;
            }
            this.magnitude = Math.sqrt(this.magnitude);
        }
        return this.magnitude;
    }

    @Override
    public void set(int n, Number number) {
        this.vector.set(n, number.doubleValue() == 0.0 ? (Number)null : (Number)number);
        this.magnitude = -1.0;
    }
}

