/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;

public class ScaledDoubleVector
implements DoubleVector {
    private DoubleVector vector;
    private double scale;

    public ScaledDoubleVector(DoubleVector doubleVector, double d) {
        if (d == 0.0) {
            throw new IllegalArgumentException("Cannot scale a vector by 0");
        }
        if (doubleVector instanceof ScaledDoubleVector) {
            ScaledDoubleVector scaledDoubleVector = (ScaledDoubleVector)doubleVector;
            this.vector = scaledDoubleVector.vector;
            this.scale = d * scaledDoubleVector.scale;
        } else {
            this.vector = doubleVector;
            this.scale = d;
        }
    }

    @Override
    public double add(int n, double d) {
        return this.vector.add(n, d / this.scale) * this.scale;
    }

    @Override
    public double get(int n) {
        return this.vector.get(n) * this.scale;
    }

    public DoubleVector getBackingVector() {
        return this.vector;
    }

    public double getScalar() {
        return this.scale;
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    @Override
    public void set(int n, double d) {
        this.vector.set(n, d / this.scale);
    }

    @Override
    public void set(int n, Number number) {
        this.vector.set(n, number.doubleValue() / this.scale);
    }

    @Override
    public double magnitude() {
        double d = 0.0;
        for (int i = 0; i < this.length(); ++i) {
            d += this.get(i);
        }
        return Math.sqrt(d);
    }

    @Override
    public int length() {
        return this.vector.length();
    }

    @Override
    public double[] toArray() {
        double[] dArray = this.vector.toArray();
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * this.scale;
        }
        return dArray;
    }
}

