/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.MaskedDoubleVectorView;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import java.util.Arrays;
import java.util.Map;

public class MaskedSparseDoubleVectorView
extends MaskedDoubleVectorView
implements SparseDoubleVector {
    private static final long serialVersionUID = 1L;
    private final SparseVector sparseVector;
    private final Map<Integer, Integer> reverseColumnMask;

    public <T extends DoubleVector & SparseVector<Double>> MaskedSparseDoubleVectorView(T t, int[] nArray, Map<Integer, Integer> map) {
        super(t, nArray);
        this.sparseVector = t;
        this.reverseColumnMask = map;
    }

    @Override
    public int[] getNonZeroIndices() {
        int[] nArray = this.sparseVector.getNonZeroIndices();
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            Integer n2 = this.reverseColumnMask.get(nArray[i]);
            if (n2 == null) continue;
            nArray2[n++] = n2;
        }
        return Arrays.copyOf(nArray2, n);
    }
}

