/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.IntAsDoubleVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import java.util.Arrays;

class IntAsSparseDoubleVector
extends IntAsDoubleVector
implements SparseDoubleVector {
    private static final long serialVersionUID = 1L;
    private final SparseVector sparseVector;

    public <T extends IntegerVector & SparseVector<Integer>> IntAsSparseDoubleVector(T t) {
        this(t, 0, t.length(), false);
    }

    public <T extends IntegerVector & SparseVector<Integer>> IntAsSparseDoubleVector(T t, boolean bl) {
        this(t, 0, t.length(), bl);
    }

    public <T extends IntegerVector & SparseVector<Integer>> IntAsSparseDoubleVector(T t, int n, int n2) {
        this(t, n, n2, false);
    }

    public <T extends IntegerVector & SparseVector<Integer>> IntAsSparseDoubleVector(T t, int n, int n2, boolean bl) {
        super(t, n, n2, bl);
        this.sparseVector = t;
    }

    @Override
    public int[] getNonZeroIndices() {
        if (this.vectorOffset == 0) {
            return this.sparseVector.getNonZeroIndices();
        }
        int[] nArray = this.sparseVector.getNonZeroIndices();
        Arrays.sort(nArray);
        int n = 0;
        int n2 = nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < this.vectorOffset) {
                ++n;
                continue;
            }
            if (nArray[i] <= this.vectorOffset + this.vectorLength) continue;
            n2 = i - 1;
            break;
        }
        if (n == n2) {
            return new int[0];
        }
        int[] nArray2 = new int[n2 - n];
        System.arraycopy(nArray, n, nArray2, 0, nArray2.length);
        return nArray2;
    }
}

