/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.IntegerVector;
import java.io.Serializable;
import java.util.Arrays;

class IntArrayAsVector
implements IntegerVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] array;

    public IntArrayAsVector(int[] nArray) {
        assert (nArray != null) : "wrapped array cannot be null";
        this.array = nArray;
    }

    @Override
    public int add(int n, int n2) {
        int n3 = n;
        int n4 = this.array[n3] + n2;
        this.array[n3] = n4;
        return n4;
    }

    @Override
    public void set(int n, int n2) {
        this.array[n] = n2;
    }

    @Override
    public void set(int n, Number number) {
        this.array[n] = number.intValue();
    }

    @Override
    public int get(int n) {
        return this.array[n];
    }

    @Override
    public Integer getValue(int n) {
        return this.array[n];
    }

    @Override
    public double magnitude() {
        double d = 0.0;
        for (int n : this.array) {
            d += (double)(n * n);
        }
        return Math.sqrt(d);
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public int length() {
        return this.array.length;
    }
}

