/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;
import java.io.Serializable;
import java.util.Arrays;

class DoubleArrayAsVector
implements DoubleVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] array;

    public DoubleArrayAsVector(double[] dArray) {
        assert (dArray != null) : "wrapped array cannot be null";
        this.array = dArray;
    }

    @Override
    public double add(int n, double d) {
        int n2 = n;
        double d2 = this.array[n2] + d;
        this.array[n2] = d2;
        return d2;
    }

    @Override
    public void set(int n, double d) {
        this.array[n] = d;
    }

    @Override
    public void set(int n, Number number) {
        this.array[n] = number.doubleValue();
    }

    @Override
    public double get(int n) {
        return this.array[n];
    }

    @Override
    public Double getValue(int n) {
        return this.array[n];
    }

    @Override
    public double magnitude() {
        double d = 0.0;
        for (double d2 : this.array) {
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.array, this.array.length);
    }

    @Override
    public int length() {
        return this.array.length;
    }
}

