/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.DoubleEntry;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.Serializable;
import java.util.Arrays;

public class DenseVector
implements DoubleVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private double[] vector;
    private double magnitude;

    public DenseVector(int n) {
        this.vector = new double[n];
        this.magnitude = 0.0;
    }

    public DenseVector(double[] dArray) {
        this.vector = Arrays.copyOf(dArray, dArray.length);
        this.magnitude = -1.0;
    }

    public DenseVector(DoubleVector doubleVector) {
        this.vector = new double[doubleVector.length()];
        this.magnitude = doubleVector.magnitude();
        if (doubleVector instanceof Iterable) {
            for (DoubleEntry doubleEntry : (Iterable)((Object)doubleVector)) {
                this.vector[doubleEntry.index()] = doubleEntry.value();
            }
        } else if (doubleVector instanceof SparseDoubleVector) {
            for (int n : ((SparseDoubleVector)doubleVector).getNonZeroIndices()) {
                this.vector[n] = doubleVector.get(n);
            }
        } else {
            for (int i = 0; i < doubleVector.length(); ++i) {
                this.vector[i] = doubleVector.get(i);
            }
        }
    }

    @Override
    public double add(int n, double d) {
        this.magnitude = -1.0;
        int n2 = n;
        this.vector[n2] = this.vector[n2] + d;
        return this.vector[n];
    }

    @Override
    public void set(int n, double d) {
        this.magnitude = -1.0;
        this.vector[n] = d;
    }

    @Override
    public void set(int n, Number number) {
        this.magnitude = -1.0;
        this.set(n, number.doubleValue());
    }

    @Override
    public double get(int n) {
        return this.vector[n];
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            for (double d2 : this.vector) {
                d += d2 * d2;
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.vector, this.vector.length);
    }

    @Override
    public int length() {
        return this.vector.length;
    }
}

