/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.IntegerEntry;
import edu.ucla.sspace.util.SparseIntArray;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.SparseIntegerVector;
import edu.ucla.sspace.vector.SparseVector;
import java.io.Serializable;
import java.util.Iterator;

public class CompactSparseIntegerVector
implements SparseIntegerVector,
Serializable,
Iterable<IntegerEntry> {
    private static final long serialVersionUID = 1L;
    private final SparseIntArray intArray;
    private double magnitude;

    public CompactSparseIntegerVector(int n) {
        this.intArray = new SparseIntArray(n);
        this.magnitude = 0.0;
    }

    public CompactSparseIntegerVector(IntegerVector integerVector) {
        this.intArray = new SparseIntArray(integerVector.length());
        if (integerVector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)integerVector);
            for (int n : sparseVector.getNonZeroIndices()) {
                this.intArray.set(n, integerVector.get(n));
            }
        } else {
            for (int i = 0; i < integerVector.length(); ++i) {
                this.intArray.set(i, integerVector.get(i));
            }
        }
        this.magnitude = -1.0;
    }

    public CompactSparseIntegerVector(int[] nArray) {
        this.intArray = new SparseIntArray(nArray);
        this.magnitude = -1.0;
    }

    @Override
    public int add(int n, int n2) {
        this.magnitude = -1.0;
        return this.intArray.addPrimitive(n, n2);
    }

    @Override
    public int get(int n) {
        return this.intArray.getPrimitive(n);
    }

    @Override
    public Integer getValue(int n) {
        return this.get(n);
    }

    @Override
    public int[] getNonZeroIndices() {
        return this.intArray.getElementIndices();
    }

    @Override
    public Iterator<IntegerEntry> iterator() {
        return this.intArray.iterator();
    }

    @Override
    public int length() {
        return this.intArray.length();
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            for (int n : this.getNonZeroIndices()) {
                int n2 = this.intArray.get(n);
                d += (double)(n2 * n2);
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }

    @Override
    public void set(int n, int n2) {
        this.intArray.set(n, n2);
        this.magnitude = -1.0;
    }

    @Override
    public void set(int n, Number number) {
        this.set(n, number.intValue());
        this.magnitude = -1.0;
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.intArray.length()];
        for (int n : this.intArray.getElementIndices()) {
            nArray[n] = this.intArray.getPrimitive(n);
        }
        return nArray;
    }
}

