/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AtomicVector
implements DoubleVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DoubleVector vector;
    private final Lock readLock;
    private final Lock writeLock;

    public AtomicVector(DoubleVector doubleVector) {
        this.vector = doubleVector;
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
    }

    public double addAndGet(int n, double d) {
        return this.add(n, d);
    }

    public double getAndAdd(int n, double d) {
        this.writeLock.lock();
        double d2 = this.vector.get(n);
        this.vector.set(n, d2 + d);
        this.writeLock.unlock();
        return d2;
    }

    @Override
    public double add(int n, double d) {
        this.writeLock.lock();
        double d2 = this.vector.add(n, d);
        this.writeLock.unlock();
        return d2;
    }

    @Override
    public double get(int n) {
        this.readLock.lock();
        double d = this.vector.get(n);
        this.readLock.unlock();
        return d;
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    public DoubleVector getVector() {
        return this.vector;
    }

    @Override
    public double magnitude() {
        this.readLock.lock();
        double d = this.vector.magnitude();
        this.readLock.unlock();
        return d;
    }

    @Override
    public void set(int n, double d) {
        this.writeLock.lock();
        this.vector.set(n, d);
        this.writeLock.unlock();
    }

    @Override
    public void set(int n, Number number) {
        this.set(n, number.doubleValue());
    }

    @Override
    public double[] toArray() {
        this.readLock.lock();
        double[] dArray = this.vector.toArray();
        this.readLock.lock();
        return dArray;
    }

    @Override
    public int length() {
        this.readLock.lock();
        int n = this.vector.length();
        this.readLock.unlock();
        return n;
    }
}

