/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AmortizedSparseVector
implements SparseDoubleVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<IndexValue> values;
    private CellComparator comp;
    private int maxLength;
    private int knownLength;

    public AmortizedSparseVector() {
        this(Integer.MAX_VALUE);
        this.knownLength = 0;
    }

    public AmortizedSparseVector(int n) {
        this.knownLength = n;
        this.maxLength = n;
        this.values = new ArrayList<IndexValue>();
        this.comp = new CellComparator();
    }

    @Override
    public double add(int n, double d) {
        this.checkIndex(n);
        double d2 = this.get(n) + d;
        this.set(n, d2);
        return d2;
    }

    @Override
    public double get(int n) {
        this.checkIndex(n);
        IndexValue indexValue = new IndexValue(n, 0.0);
        int n2 = Collections.binarySearch(this.values, indexValue, this.comp);
        return n2 >= 0 ? this.values.get((int)n2).value : 0.0;
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    @Override
    public double magnitude() {
        double d = 0.0;
        for (IndexValue indexValue : this.values) {
            d += indexValue.value * indexValue.value;
        }
        return Math.sqrt(d);
    }

    @Override
    public void set(int n, double d) {
        this.checkIndex(n);
        IndexValue indexValue = new IndexValue(n, 0.0);
        int n2 = Collections.binarySearch(this.values, indexValue, this.comp);
        if (n2 >= 0 && d != 0.0) {
            this.values.get((int)n2).value = d;
        } else if (d != 0.0) {
            indexValue.value = d;
            this.values.add((n2 + 1) * -1, indexValue);
        } else if (n2 >= 0) {
            this.values.remove(n2);
        }
    }

    @Override
    public void set(int n, Number number) {
        this.set(n, number.doubleValue());
    }

    public void set(double[] dArray) {
        this.checkIndex(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            this.set(i, dArray[i]);
        }
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.length()];
        for (IndexValue indexValue : this.values) {
            dArray[indexValue.index] = indexValue.value;
        }
        return dArray;
    }

    @Override
    public int[] getNonZeroIndices() {
        int[] nArray = new int[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            nArray[i] = this.values.get((int)i).index;
        }
        return nArray;
    }

    @Override
    public int length() {
        return this.knownLength;
    }

    private void checkIndex(int n) {
        if (this.maxLength == Integer.MAX_VALUE && this.knownLength < n) {
            this.knownLength = n;
        } else if (n < 0 || n >= this.maxLength) {
            throw new IllegalArgumentException("Length must be non negative and less than the maximum length");
        }
    }

    private static class CellComparator
    implements Comparator<IndexValue>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CellComparator() {
        }

        @Override
        public int compare(IndexValue indexValue, IndexValue indexValue2) {
            return indexValue.index - indexValue2.index;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }

    private static class IndexValue {
        public int index;
        public double value;

        public IndexValue(int n, double d) {
            this.index = n;
            this.value = d;
        }
    }
}

