/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.CharMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TrieMap<V>
extends AbstractMap<String, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RootNode<V> rootNode = new RootNode();
    private int size = 0;

    public TrieMap() {
    }

    public TrieMap(Map<String, ? extends V> map) {
        this();
        if (map == null) {
            throw new NullPointerException("map cannot be null");
        }
        this.putAll(map);
    }

    private void checkKey(Object object) {
        if (object == null) {
            throw new NullPointerException("keys cannot be null");
        }
        if (!(object instanceof String)) {
            throw new ClassCastException("key not an instance of String");
        }
    }

    @Override
    public void clear() {
        this.rootNode.clear();
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (object instanceof String) {
            Node<V> node = this.lookup((String)object);
            return node != null && node.isTerminal();
        }
        throw new ClassCastException("The provided key does not implement String: " + object);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new EntryView();
    }

    @Override
    public V get(Object object) {
        this.checkKey(object);
        String string = (String)object;
        Node<V> node = this.lookup(string);
        return (V)(node == null ? null : ((Node)node).value);
    }

    @Override
    public Set<String> keySet() {
        return new KeyView();
    }

    private Node<V> lookup(String string) {
        if (string == null) {
            throw new NullPointerException("key cannot be null");
        }
        int n = string.length();
        Node node = this.rootNode;
        for (int i = 0; i <= n; ++i) {
            CharSequence charSequence = node.getPrefix();
            if (charSequence.length() > 0) {
                int n2;
                int n3 = this.countOverlap(string, i, charSequence, 0);
                if (n3 < (n2 = charSequence.length())) {
                    return null;
                }
                i += n2;
            }
            if (i == n) {
                return node;
            }
            Node node2 = node.getChild(string.charAt(i));
            if (node2 == null) {
                return null;
            }
            node = node2;
        }
        assert (false);
        return null;
    }

    @Override
    public V put(String string, V v) {
        if (string == null || v == null) {
            throw new NullPointerException("keys and values cannot be null");
        }
        int n = string.length();
        Node node = this.rootNode;
        for (int i = 0; i <= n; ++i) {
            CharSequence charSequence = node.getPrefix();
            int n2 = i + 1;
            if (charSequence.length() > 0) {
                int n3;
                int n4 = this.countOverlap(string, i, charSequence, 0);
                if (n4 < (n3 = charSequence.length())) {
                    this.addIntermediateNode(node, n4, string, i, v);
                    ++this.size;
                    return null;
                }
                n2 = (i += n3) + 1;
            }
            if (i == n) {
                return this.replaceValue(node, v);
            }
            Node node2 = node.getChild(string.charAt(i));
            if (node2 == null) {
                this.addChildNode(node, string, i, v);
                return null;
            }
            node = node2;
        }
        return null;
    }

    private int countOverlap(CharSequence charSequence, int n, CharSequence charSequence2, int n2) {
        int n3;
        int n4 = Math.min(charSequence.length() - n, charSequence2.length() - n2);
        for (n3 = 0; n3 < n4 && charSequence.charAt(n3 + n) == charSequence2.charAt(n3 + n2); ++n3) {
        }
        return n3;
    }

    @Override
    public V remove(Object object) {
        this.checkKey(object);
        String string = (String)object;
        Node<V> node = this.lookup(string);
        if (node != null && node.isTerminal()) {
            Object object2 = ((Node)node).value;
            ((Node)node).value = null;
            --this.size;
            return (V)object2;
        }
        return (V)(node == null ? null : ((Node)node).value);
    }

    private V replaceValue(Node<V> node, V v) {
        if (node.isTerminal()) {
            Object object = ((Node)node).value;
            ((Node)node).value = v;
            return (V)object;
        }
        ((Node)node).value = v;
        ++this.size;
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void addChildNode(Node<V> node, String string, int n, V v) {
        char c = string.charAt(n);
        Node<V> node2 = new Node<V>(string, n + 1, v);
        node.addChild(c, node2);
        ++this.size;
    }

    private void addIntermediateNode(Node<V> node, int n, String string, int n2, V v) {
        char[] cArray = ((Node)node).prefix;
        char c = cArray[n];
        char[] cArray2 = Arrays.copyOfRange(cArray, n + 1, cArray.length);
        char[] cArray3 = Arrays.copyOfRange(cArray, 0, n);
        Node<Object> node2 = new Node<Object>(cArray2, ((Node)node).value);
        node2.children = node.children;
        Node.access$302(node, cArray3);
        node.children = new CharMap();
        node.addChild(c, node2);
        int n3 = string.length() - n2;
        if (n == n3) {
            ((Node)node).value = v;
        } else {
            int n4 = n2 + n + 1;
            char c2 = string.charAt(n2 + n);
            char[] cArray4 = new char[string.length() - n4];
            for (int i = 0; i < cArray4.length; ++i) {
                cArray4[i] = string.charAt(n4 + i);
            }
            Node<V> node3 = new Node<V>(cArray4, v);
            node.addChild(c2, node3);
            ((Node)node).value = null;
        }
    }

    @Override
    public Collection<V> values() {
        return new ValueView();
    }

    private class EntryView
    extends AbstractSet<Map.Entry<String, V>> {
        private EntryView() {
        }

        @Override
        public void clear() {
            TrieMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                Object v2 = TrieMap.this.get(k);
                return v2 == v || v != null && v.equals(v2);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return TrieMap.this.size;
        }
    }

    private class ValueView
    extends AbstractCollection<V> {
        private ValueView() {
        }

        @Override
        public void clear() {
            TrieMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return TrieMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return TrieMap.this.size;
        }
    }

    private class KeyView
    extends AbstractSet<String> {
        private KeyView() {
        }

        @Override
        public void clear() {
            TrieMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return TrieMap.this.containsKey(object);
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            return TrieMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return TrieMap.this.size;
        }
    }

    private static class TrieEntry<V>
    extends AbstractMap.SimpleEntry<String, V> {
        private static final long serialVersionUID = 1L;
        private final Node<V> node;

        public TrieEntry(String string, Node<V> node) {
            super(string, ((Node)node).value);
            this.node = node;
        }

        @Override
        public V getValue() {
            return (V)((Node)this.node).value;
        }

        @Override
        public V setValue(V v) {
            return this.node.setValue(v);
        }
    }

    private class ValueIterator
    extends TrieIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends TrieIterator<String> {
        private KeyIterator() {
        }

        @Override
        public String next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends TrieIterator<Map.Entry<String, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<String, V> next() {
            return this.nextEntry();
        }
    }

    private abstract class TrieIterator<E>
    implements Iterator<E> {
        private final Deque<AnnotatedNode<V>> dfsFrontier = new ArrayDeque();
        private Map.Entry<String, V> next;
        private Map.Entry<String, V> prev;

        public TrieIterator() {
            for (Map.Entry entry : TrieMap.this.rootNode.getChildren().entrySet()) {
                this.dfsFrontier.offer(new AnnotatedNode(entry.getValue(), entry.getKey().toString()));
            }
            this.next = null;
            this.prev = null;
            this.advance();
        }

        private void advance() {
            Map.Entry[] entryArray;
            int n;
            Map.Entry[] entryArray2;
            AnnotatedNode annotatedNode = this.dfsFrontier.pollFirst();
            while (annotatedNode != null && !annotatedNode.node.isTerminal()) {
                entryArray2 = new Map.Entry[annotatedNode.node.getChildren().size()];
                n = 1;
                entryArray = annotatedNode.node.getChildren().entrySet().iterator();
                while (entryArray.hasNext()) {
                    Map.Entry entry;
                    entryArray2[entryArray2.length - n] = entry = entryArray.next();
                    ++n;
                }
                for (Map.Entry entry : entryArray2) {
                    this.dfsFrontier.push(new AnnotatedNode((Node)entry.getValue(), annotatedNode.prefix + annotatedNode.node.getPrefix() + entry.getKey()));
                }
                annotatedNode = this.dfsFrontier.pollFirst();
            }
            if (annotatedNode == null) {
                this.next = null;
            } else {
                this.next = this.createEntry(annotatedNode);
                entryArray2 = new Map.Entry[annotatedNode.node.getChildren().size()];
                n = 1;
                entryArray = annotatedNode.node.getChildren().entrySet().iterator();
                while (entryArray.hasNext()) {
                    Map.Entry entry;
                    entryArray2[entryArray2.length - n] = entry = (Map.Entry)entryArray.next();
                    ++n;
                }
                for (Map.Entry entry : entryArray2) {
                    this.dfsFrontier.push(new AnnotatedNode((Node)entry.getValue(), annotatedNode.prefix + annotatedNode.node.getPrefix() + entry.getKey()));
                }
            }
        }

        private Map.Entry<String, V> createEntry(AnnotatedNode<V> annotatedNode) {
            String string = annotatedNode.prefix + annotatedNode.node.getPrefix();
            return new TrieEntry(string, annotatedNode.node);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Map.Entry<String, V> nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException("no further elements");
            }
            this.prev = this.next;
            this.advance();
            return this.prev;
        }

        @Override
        public void remove() {
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            TrieMap.this.remove(this.prev.getKey());
            this.prev = null;
        }
    }

    private static class AnnotatedNode<V> {
        private final String prefix;
        private final Node<V> node;

        public AnnotatedNode(Node<V> node, String string) {
            this.prefix = string;
            this.node = node;
        }

        public String toString() {
            return this.node.toString();
        }
    }

    private static class ArraySequence
    implements CharSequence,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final char[] sequence;

        public ArraySequence(char[] cArray) {
            this.sequence = cArray;
        }

        @Override
        public char charAt(int n) {
            return this.sequence[n];
        }

        public boolean equals(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.length() != this.sequence.length) {
                    return false;
                }
                for (int i = 0; i < this.sequence.length; ++i) {
                    if (string.charAt(i) == this.sequence[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.sequence);
        }

        @Override
        public int length() {
            return this.sequence.length;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new ArraySequence(Arrays.copyOfRange(this.sequence, n, n2));
        }

        @Override
        public String toString() {
            return new String(this.sequence);
        }
    }

    private static class RootNode<V>
    extends Node<V> {
        private static final long serialVersionUID = 1L;

        public RootNode() {
            super("", null);
            this.children = new CharMap();
        }

        public void clear() {
            this.children.clear();
        }

        @Override
        void setTail(String string) {
            throw new IllegalStateException("cannot set tail on root node");
        }

        @Override
        public V setValue(V v) {
            return super.setValue(v);
        }

        boolean tailMatches(String string) {
            return string.length() == 0;
        }
    }

    private static class Node<V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private char[] prefix;
        private V value;
        protected Map<Character, Node<V>> children;

        Node(String string, int n, V v) {
            this(Node.toArray(string, n), v);
        }

        Node(char[] cArray, V v) {
            this.prefix = cArray;
            this.value = v;
            this.children = null;
        }

        public Node(String string, V v) {
            this(string, 0, v);
        }

        public void addChild(char c, Node<V> node) {
            if (this.children == null) {
                this.children = new CharMap<Node<V>>();
            }
            this.children.put(Character.valueOf(c), node);
        }

        public Node<V> getChild(char c) {
            return this.children == null ? null : this.children.get(Character.valueOf(c));
        }

        public Map<Character, Node<V>> getChildren() {
            return this.children == null ? new HashMap() : this.children;
        }

        public CharSequence getPrefix() {
            return new ArraySequence(this.prefix);
        }

        public boolean isTerminal() {
            return this.value != null;
        }

        void setTail(String string) {
            this.prefix = Node.toArray(string);
        }

        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException("TrieMap values cannot be null");
            }
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        boolean prefixMatches(String string) {
            if (string.length() == this.prefix.length) {
                for (int i = 0; i < this.prefix.length; ++i) {
                    if (string.charAt(i) == this.prefix[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static char[] toArray(String string) {
            return Node.toArray(string, 0);
        }

        private static char[] toArray(String string, int n) {
            char[] cArray = new char[string.length() - n];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = string.charAt(i + n);
            }
            return cArray;
        }

        public String toString() {
            return "(" + (this.prefix.length == 0 ? "\"\"" : new String(this.prefix)) + ": " + this.value + ", children: " + this.children + ")";
        }

        static /* synthetic */ char[] access$302(Node node, char[] cArray) {
            node.prefix = cArray;
            return cArray;
        }
    }
}

