/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.CombinedIterator;
import edu.ucla.sspace.util.MultiMap;
import edu.ucla.sspace.util.SortedMultiMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class TreeMultiMap<K, V>
implements SortedMultiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SortedMap<K, Set<V>> map;
    private int range;
    private boolean recalculateRange;
    private final TreeMultiMap<K, V> parent;

    public TreeMultiMap() {
        this.map = new TreeMap<K, Set<V>>();
        this.range = 0;
        this.recalculateRange = false;
        this.parent = null;
    }

    public TreeMultiMap(Comparator<? super K> comparator) {
        this.map = new TreeMap<K, Set<V>>(comparator);
        this.range = 0;
        this.recalculateRange = false;
        this.parent = null;
    }

    public TreeMultiMap(Map<? extends K, ? extends V> map) {
        this();
        this.putAll(map);
    }

    private TreeMultiMap(SortedMap<K, Set<V>> sortedMap, TreeMultiMap<K, V> treeMultiMap) {
        this.map = sortedMap;
        this.range = -1;
        this.recalculateRange = true;
        this.parent = treeMultiMap;
    }

    @Override
    public Map<K, Set<V>> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void clear() {
        this.map.clear();
        if (this.parent != null) {
            int n = this.range();
            super.updateParentRange(-n);
        }
        this.range = 0;
    }

    private void updateParentRange(int n) {
        this.range += n;
        if (this.parent != null) {
            super.updateParentRange(n);
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.map.comparator();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        for (Set<V> set : this.map.values()) {
            if (!set.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Override
    public K firstKey() {
        return this.map.firstKey();
    }

    @Override
    public Set<V> get(Object object) {
        return (Set)this.map.get(object);
    }

    @Override
    public SortedMultiMap<K, V> headMap(K k) {
        return new TreeMultiMap<K, V>(this.map.headMap(k), this);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public K lastKey() {
        return this.map.lastKey();
    }

    @Override
    public boolean put(K k, V v) {
        boolean bl;
        HashSet<V> hashSet = (HashSet<V>)this.map.get(k);
        if (hashSet == null) {
            hashSet = new HashSet<V>();
            this.map.put(k, hashSet);
        }
        if (bl = hashSet.add(v)) {
            ++this.range;
            if (this.parent != null) {
                super.updateParentRange(1);
            }
        }
        return bl;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(MultiMap<? extends K, ? extends V> multiMap) {
        for (Map.Entry<K, V> entry : multiMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean putMulti(K k, Collection<V> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        HashSet<V> hashSet = (HashSet<V>)this.map.get(k);
        if (hashSet == null) {
            hashSet = new HashSet<V>();
            this.map.put(k, hashSet);
        }
        int n = hashSet.size();
        boolean bl = hashSet.addAll(collection);
        this.range += hashSet.size() - n;
        return bl;
    }

    @Override
    public int range() {
        if (this.recalculateRange) {
            this.recalculateRange = false;
            this.range = 0;
            for (V v : this.values()) {
                ++this.range;
            }
        }
        return this.range;
    }

    @Override
    public Set<V> remove(Object object) {
        Set set = (Set)this.map.remove(object);
        if (set != null) {
            this.range -= set.size();
        }
        if (this.parent != null) {
            super.updateParentRange(-set.size());
        }
        return set;
    }

    @Override
    public boolean remove(K k, V v) {
        Set set = (Set)this.map.get(k);
        boolean bl = set.remove(v);
        if (bl) {
            --this.range;
            if (this.parent != null) {
                super.updateParentRange(-1);
            }
        }
        if (set.size() == 0) {
            this.map.remove(k);
        }
        return bl;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public SortedMultiMap<K, V> subMap(K k, K k2) {
        return new TreeMultiMap<K, V>(this.map.subMap(k, k2), this);
    }

    @Override
    public SortedMultiMap<K, V> tailMap(K k) {
        return new TreeMultiMap<K, V>(this.map.tailMap(k), this);
    }

    public String toString() {
        Iterator<Map.Entry<K, Set<V>>> iterator = this.map.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<K, Set<V>> entry = iterator.next();
            K k = entry.getKey();
            Set<V> set = entry.getValue();
            stringBuilder.append((Object)(k == this ? "(this Map)" : k));
            stringBuilder.append("=[");
            Iterator<V> iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                V v = iterator2.next();
                stringBuilder.append((Object)(v == this ? "(this Map)" : v));
                if (!iterator2.hasNext()) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
        }
    }

    @Override
    public Collection<V> values() {
        return new ValuesView();
    }

    class EntryIterator
    implements Iterator<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        K curKey;
        Iterator<V> curValues;
        Iterator<Map.Entry<K, Set<V>>> multiMapIterator;
        Map.Entry<K, V> next;
        Map.Entry<K, V> previous;

        public EntryIterator() {
            this.multiMapIterator = TreeMultiMap.this.map.entrySet().iterator();
            if (this.multiMapIterator.hasNext()) {
                Map.Entry entry = this.multiMapIterator.next();
                this.curKey = entry.getKey();
                this.curValues = entry.getValue().iterator();
            }
            this.advance();
        }

        private void advance() {
            if (this.curValues != null && this.curValues.hasNext()) {
                this.next = new MultiMapEntry(this.curKey, this.curValues.next());
            } else if (this.multiMapIterator.hasNext()) {
                Map.Entry entry = this.multiMapIterator.next();
                this.curKey = entry.getKey();
                this.curValues = entry.getValue().iterator();
                this.next = new MultiMapEntry(this.curKey, this.curValues.next());
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = this.next;
            this.previous = entry;
            this.advance();
            return entry;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException("No previous element to remove");
            }
            TreeMultiMap.this.remove(this.previous.getKey(), this.previous.getValue());
            this.previous = null;
        }

        private class MultiMapEntry
        extends AbstractMap.SimpleEntry<K, V>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public MultiMapEntry(K k, V v) {
                super(k, v);
            }

            @Override
            public V setValue(V v) {
                Set set = TreeMultiMap.this.get(this.getKey());
                set.remove(this.getValue());
                set.add(v);
                return super.setValue(v);
            }
        }
    }

    class EntryView
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public void clear() {
            TreeMultiMap.this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Set set = TreeMultiMap.this.get(entry.getKey());
                return set.contains(entry.getValue());
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return TreeMultiMap.this.range();
        }
    }

    class ValuesView
    extends AbstractCollection<V>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public void clear() {
            TreeMultiMap.this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            return TreeMultiMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Set set : TreeMultiMap.this.map.values()) {
                arrayList.add(set.iterator());
            }
            return new CombinedIterator(arrayList);
        }

        @Override
        public int size() {
            return TreeMultiMap.this.range();
        }
    }
}

