/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.SparseNumericArray;
import java.io.Serializable;
import java.util.Arrays;

public class SparseLongArray
implements SparseNumericArray<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxLength;
    private int[] indices;
    private long[] values;

    public SparseLongArray() {
        this(Integer.MAX_VALUE);
    }

    public SparseLongArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        this.maxLength = n;
        this.indices = new int[0];
        this.values = new long[0];
    }

    public SparseLongArray(long[] lArray) {
        int n;
        this.maxLength = lArray.length;
        int n2 = 0;
        for (n = 0; n < lArray.length; ++n) {
            if (lArray[n] == 0L) continue;
            ++n2;
        }
        this.indices = new int[n2];
        this.values = new long[n2];
        n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            this.indices[n] = i;
            this.values[n++] = lArray[i];
        }
    }

    public long addPrimitive(int n, long l) {
        if (n < 0 || n >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + n);
        }
        if (l == 0L) {
            return this.get(n);
        }
        int n2 = Arrays.binarySearch(this.indices, n);
        if (n2 < 0) {
            int n3 = 0 - (n2 + 1);
            int[] nArray = Arrays.copyOf(this.indices, this.indices.length + 1);
            long[] lArray = Arrays.copyOf(this.values, this.values.length + 1);
            for (int i = n3; i < this.values.length; ++i) {
                lArray[i + 1] = this.values[i];
                nArray[i + 1] = this.indices[i];
            }
            this.indices = nArray;
            this.values = lArray;
            n2 = n3;
            this.indices[n2] = n;
            this.values[n2] = l;
            return l;
        }
        long l2 = this.values[n2] + l;
        if (l2 == 0L) {
            int n4 = this.indices.length - 1;
            int[] nArray = new int[n4];
            long[] lArray = new long[n4];
            int n5 = 0;
            for (int i = 0; i < this.indices.length; ++i) {
                if (i == n2) continue;
                nArray[n5] = this.indices[i];
                lArray[n5] = this.values[i];
                ++n5;
            }
            this.indices = nArray;
            this.values = lArray;
        } else {
            this.values[n2] = l2;
        }
        return l2;
    }

    @Override
    public Long add(int n, Long l) {
        return this.addPrimitive(n, l);
    }

    @Override
    public int cardinality() {
        return this.indices.length;
    }

    @Override
    public Long get(int n) {
        return this.getPrimitive(n);
    }

    @Override
    public int[] getElementIndices() {
        return this.indices;
    }

    public long getPrimitive(int n) {
        if (n < 0 || n >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + n);
        }
        int n2 = Arrays.binarySearch(this.indices, n);
        long l = n2 >= 0 ? this.values[n2] : 0L;
        return l;
    }

    @Override
    public int length() {
        return this.maxLength;
    }

    @Override
    public void set(int n, Long l) {
        this.setPrimitive(n, l.intValue());
    }

    public void setPrimitive(int n, long l) {
        int n2 = Arrays.binarySearch(this.indices, n);
        if (l != 0L) {
            if (n2 < 0) {
                int n3;
                int n4 = 0 - (n2 + 1);
                int[] nArray = new int[this.indices.length + 1];
                long[] lArray = new long[this.values.length + 1];
                for (n3 = 0; n3 < n4; ++n3) {
                    lArray[n3] = this.values[n3];
                    nArray[n3] = this.indices[n3];
                }
                for (n3 = n4; n3 < this.values.length; ++n3) {
                    lArray[n3 + 1] = this.values[n3];
                    nArray[n3 + 1] = this.indices[n3];
                }
                this.indices = nArray;
                this.values = lArray;
                n2 = n4;
                this.indices[n2] = n;
            }
            this.values[n2] = l;
        } else if (l == 0L && n2 >= 0) {
            int n5 = this.indices.length - 1;
            int[] nArray = new int[n5];
            long[] lArray = new long[n5];
            int n6 = 0;
            for (int i = 0; i < this.indices.length; ++i) {
                if (i == n2) continue;
                nArray[n6] = this.indices[i];
                lArray[n6] = this.values[i];
                ++n6;
            }
            this.indices = nArray;
            this.values = lArray;
        }
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        int n = 0;
        for (int i = 0; i < EArray.length; ++i) {
            int n2 = -1;
            if (n < this.indices.length && (n2 = this.indices[n]) == i) {
                EArray[i] = this.values[n];
                ++n;
                continue;
            }
            EArray[i] = 0L;
        }
        return EArray;
    }

    public long[] toPrimitiveArray(long[] lArray) {
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            int n2 = -1;
            if (n < this.indices.length && (n2 = this.indices[n]) == i) {
                lArray[i] = this.values[n];
                ++n;
                continue;
            }
            lArray[i] = 0L;
        }
        return lArray;
    }
}

