/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.SparseArray;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SparseIntHashArray
implements SparseArray<Integer>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxLength;
    private Map<Integer, Integer> indexToValue;

    public SparseIntHashArray() {
        this(Integer.MAX_VALUE);
    }

    public SparseIntHashArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        this.maxLength = n;
        this.indexToValue = new HashMap<Integer, Integer>();
    }

    public SparseIntHashArray(int[] nArray) {
        this.maxLength = nArray.length;
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            this.indexToValue.put(i, nArray[i]);
        }
    }

    @Override
    public int cardinality() {
        return this.indexToValue.size();
    }

    @Override
    public Integer get(int n) {
        Integer n2 = this.indexToValue.get(n);
        return n2 == null ? 0 : n2;
    }

    @Override
    public int[] getElementIndices() {
        Integer[] integerArray = this.indexToValue.keySet().toArray(new Integer[0]);
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    @Override
    public int length() {
        return this.maxLength;
    }

    @Override
    public void set(int n, Integer n2) {
        if (n2 == 0) {
            this.indexToValue.remove(n);
        } else {
            this.indexToValue.put(n, n2);
        }
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        for (int i = 0; i < EArray.length; ++i) {
            Integer n = this.indexToValue.get(i);
            if (n == null) continue;
            EArray[i] = n;
        }
        return EArray;
    }
}

