/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.IntegerEntry;
import edu.ucla.sspace.util.SparseNumericArray;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SparseIntArray
implements SparseNumericArray<Integer>,
Serializable,
Iterable<IntegerEntry> {
    private static final long serialVersionUID = 1L;
    private final int maxLength;
    private int[] indices;
    private int[] values;

    public SparseIntArray() {
        this(Integer.MAX_VALUE);
    }

    public SparseIntArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        this.maxLength = n;
        this.indices = new int[0];
        this.values = new int[0];
    }

    public SparseIntArray(int[] nArray) {
        int n;
        this.maxLength = nArray.length;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            ++n2;
        }
        this.indices = new int[n2];
        this.values = new int[n2];
        n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            this.indices[n] = i;
            this.values[n++] = nArray[i];
        }
    }

    public SparseIntArray(int[] nArray, int[] nArray2, int n) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("different number of indices and values");
        }
        this.maxLength = n;
        this.indices = nArray;
        this.values = nArray2;
        for (int i = 0; i < this.indices.length - 1; ++i) {
            if (this.indices[i] > this.indices[i + 1]) continue;
            throw new IllegalArgumentException("Indices must be sorted and unique");
        }
    }

    public int addPrimitive(int n, int n2) {
        if (n < 0 || n >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + n);
        }
        if (n2 == 0) {
            return this.get(n);
        }
        int n3 = Arrays.binarySearch(this.indices, n);
        if (n3 < 0) {
            int n4 = 0 - (n3 + 1);
            int[] nArray = Arrays.copyOf(this.indices, this.indices.length + 1);
            int[] nArray2 = Arrays.copyOf(this.values, this.values.length + 1);
            for (int i = n4; i < this.values.length; ++i) {
                nArray2[i + 1] = this.values[i];
                nArray[i + 1] = this.indices[i];
            }
            this.indices = nArray;
            this.values = nArray2;
            n3 = n4;
            this.indices[n3] = n;
            this.values[n3] = n2;
            return n2;
        }
        int n5 = this.values[n3] + n2;
        if (n5 == 0) {
            int n6 = this.indices.length - 1;
            int[] nArray = new int[n6];
            int[] nArray3 = new int[n6];
            int n7 = 0;
            for (int i = 0; i < this.indices.length; ++i) {
                if (i == n3) continue;
                nArray[n7] = this.indices[i];
                nArray3[n7] = this.values[i];
                ++n7;
            }
            this.indices = nArray;
            this.values = nArray3;
        } else {
            this.values[n3] = n5;
        }
        return n5;
    }

    @Override
    public Integer add(int n, Integer n2) {
        return this.addPrimitive(n, n2);
    }

    @Override
    public int cardinality() {
        return this.indices.length;
    }

    @Override
    public Integer get(int n) {
        return this.getPrimitive(n);
    }

    @Override
    public int[] getElementIndices() {
        return this.indices;
    }

    public int getPrimitive(int n) {
        if (n < 0 || n >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + n);
        }
        int n2 = Arrays.binarySearch(this.indices, n);
        int n3 = n2 >= 0 ? this.values[n2] : 0;
        return n3;
    }

    @Override
    public Iterator<IntegerEntry> iterator() {
        return new SparseIntArrayIterator();
    }

    @Override
    public int length() {
        return this.maxLength;
    }

    @Override
    public void set(int n, Integer n2) {
        this.setPrimitive(n, n2);
    }

    public void setPrimitive(int n, int n2) {
        int n3 = Arrays.binarySearch(this.indices, n);
        if (n2 != 0) {
            if (n3 < 0) {
                int n4;
                int n5 = 0 - (n3 + 1);
                int[] nArray = new int[this.indices.length + 1];
                int[] nArray2 = new int[this.values.length + 1];
                for (n4 = 0; n4 < n5; ++n4) {
                    nArray2[n4] = this.values[n4];
                    nArray[n4] = this.indices[n4];
                }
                for (n4 = n5; n4 < this.values.length; ++n4) {
                    nArray2[n4 + 1] = this.values[n4];
                    nArray[n4 + 1] = this.indices[n4];
                }
                this.indices = nArray;
                this.values = nArray2;
                n3 = n5;
                this.indices[n3] = n;
            }
            this.values[n3] = n2;
        } else if (n2 == 0 && n3 >= 0) {
            int n6 = this.indices.length - 1;
            int[] nArray = new int[n6];
            int[] nArray3 = new int[n6];
            int n7 = 0;
            for (int i = 0; i < this.indices.length; ++i) {
                if (i == n3) continue;
                nArray[n7] = this.indices[i];
                nArray3[n7] = this.values[i];
                ++n7;
            }
            this.indices = nArray;
            this.values = nArray3;
        }
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        int n = 0;
        for (int i = 0; i < EArray.length; ++i) {
            int n2 = -1;
            if (n < this.indices.length && (n2 = this.indices[n]) == i) {
                EArray[i] = this.values[n];
                ++n;
                continue;
            }
            EArray[i] = 0;
        }
        return EArray;
    }

    public int[] toPrimitiveArray(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = -1;
            if (n < this.indices.length && (n2 = this.indices[n]) == i) {
                nArray[i] = this.values[n];
                ++n;
                continue;
            }
            nArray[i] = 0;
        }
        return nArray;
    }

    private class SparseIntArrayIterator
    implements Iterator<IntegerEntry> {
        int curIndex = 0;
        IntegerEntryImpl e = new IntegerEntryImpl(-1, -1);

        @Override
        public boolean hasNext() {
            return SparseIntArray.this.indices.length > this.curIndex;
        }

        @Override
        public IntegerEntry next() {
            if (SparseIntArray.this.indices.length <= this.curIndex) {
                throw new NoSuchElementException();
            }
            this.e.index = SparseIntArray.this.indices[this.curIndex];
            this.e.val = SparseIntArray.this.values[this.curIndex];
            ++this.curIndex;
            return this.e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class IntegerEntryImpl
        implements IntegerEntry {
            public int index;
            public int val;

            public IntegerEntryImpl(int n, int n2) {
                this.index = n;
                this.val = n2;
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public int value() {
                return this.val;
            }

            public String toString() {
                return "[" + this.index + "->" + this.val + "]";
            }
        }
    }
}

