/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.ObjectEntry;
import edu.ucla.sspace.util.SparseArray;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SparseHashArray<T>
implements SparseArray<T>,
Iterable<ObjectEntry<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxLength;
    private Map<Integer, T> indexToValue;
    private int[] indices;

    public SparseHashArray() {
        this(Integer.MAX_VALUE);
    }

    public SparseHashArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        this.maxLength = n;
        this.indices = null;
        this.indexToValue = new HashMap<Integer, T>();
    }

    public SparseHashArray(T[] TArray) {
        this.maxLength = TArray.length;
        this.indices = null;
        boolean bl = false;
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == null) continue;
            this.indexToValue.put(i, TArray[i]);
        }
    }

    @Override
    public int cardinality() {
        return this.indexToValue.size();
    }

    @Override
    public T get(int n) {
        return this.indexToValue.get(n);
    }

    @Override
    public int[] getElementIndices() {
        if (this.indices != null) {
            return this.indices;
        }
        Integer[] integerArray = this.indexToValue.keySet().toArray(new Integer[0]);
        this.indices = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            this.indices[i] = integerArray[i];
        }
        Arrays.sort(this.indices);
        return this.indices;
    }

    @Override
    public Iterator<ObjectEntry<T>> iterator() {
        return new SparseHashArrayIterator();
    }

    @Override
    public int length() {
        return this.maxLength;
    }

    @Override
    public void set(int n, T t) {
        if (t != null) {
            if (this.indexToValue.put(n, t) == null) {
                this.indices = null;
            }
        } else if (this.indexToValue.remove(n) != null) {
            this.indices = null;
        }
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        for (int i = 0; i < EArray.length; ++i) {
            T t = this.indexToValue.get(i);
            if (t == null) continue;
            EArray[i] = t;
        }
        return EArray;
    }

    private class SparseHashArrayIterator
    implements Iterator<ObjectEntry<T>> {
        Iterator<Map.Entry<Integer, T>> arrayIter;

        public SparseHashArrayIterator() {
            this.arrayIter = SparseHashArray.this.indexToValue.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.arrayIter.hasNext();
        }

        @Override
        public ObjectEntry<T> next() {
            final Map.Entry entry = this.arrayIter.next();
            return new ObjectEntry<T>(){

                @Override
                public int index() {
                    return (Integer)entry.getKey();
                }

                @Override
                public T value() {
                    return entry.getValue();
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

