/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.DoubleEntry;
import edu.ucla.sspace.util.SparseNumericArray;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SparseDoubleArray
implements SparseNumericArray<Double>,
Serializable,
Iterable<DoubleEntry> {
    private static final long serialVersionUID = 1L;
    private final int maxLength;
    private int[] indices;
    private double[] values;

    public SparseDoubleArray() {
        this(Integer.MAX_VALUE);
    }

    public SparseDoubleArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length must be non-negative");
        }
        this.maxLength = n;
        this.indices = new int[0];
        this.values = new double[0];
    }

    public SparseDoubleArray(double[] dArray) {
        int n;
        this.maxLength = dArray.length;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] == 0.0) continue;
            ++n2;
        }
        this.indices = new int[n2];
        this.values = new double[n2];
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            this.indices[n] = i;
            this.values[n++] = dArray[i];
        }
    }

    public SparseDoubleArray(int[] nArray, double[] dArray, int n) {
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("different number of indices and values");
        }
        this.maxLength = n;
        this.indices = nArray;
        this.values = dArray;
        for (int i = 0; i < this.indices.length - 1; ++i) {
            if (this.indices[i] < this.indices[i + 1]) continue;
            throw new IllegalArgumentException("Indices must be sorted and unique.  Given " + this.indices[i] + " and " + this.indices[i + 1]);
        }
    }

    public double addPrimitive(int n, double d) {
        if (n < 0 || n >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + n);
        }
        if (d == 0.0) {
            return this.get(n);
        }
        int n2 = Arrays.binarySearch(this.indices, n);
        if (n2 < 0) {
            int n3 = 0 - (n2 + 1);
            int[] nArray = Arrays.copyOf(this.indices, this.indices.length + 1);
            double[] dArray = Arrays.copyOf(this.values, this.values.length + 1);
            for (int i = n3; i < this.values.length; ++i) {
                dArray[i + 1] = this.values[i];
                nArray[i + 1] = this.indices[i];
            }
            this.indices = nArray;
            this.values = dArray;
            n2 = n3;
            this.indices[n2] = n;
            this.values[n2] = d;
            return d;
        }
        double d2 = this.values[n2] + d;
        if (d2 == 0.0) {
            int n4 = this.indices.length - 1;
            int[] nArray = new int[n4];
            double[] dArray = new double[n4];
            int n5 = 0;
            for (int i = 0; i < this.indices.length; ++i) {
                if (i == n2) continue;
                nArray[n5] = this.indices[i];
                dArray[n5] = this.values[i];
                ++n5;
            }
            this.indices = nArray;
            this.values = dArray;
        } else {
            this.values[n2] = d2;
        }
        return d2;
    }

    @Override
    public Double add(int n, Double d) {
        return this.addPrimitive(n, d);
    }

    @Override
    public int cardinality() {
        return this.indices.length;
    }

    @Override
    public Double get(int n) {
        return this.getPrimitive(n);
    }

    @Override
    public int[] getElementIndices() {
        return this.indices;
    }

    public double getPrimitive(int n) {
        if (n < 0 || n >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("invalid index: " + n);
        }
        int n2 = Arrays.binarySearch(this.indices, n);
        double d = n2 >= 0 ? this.values[n2] : 0.0;
        return d;
    }

    @Override
    public Iterator<DoubleEntry> iterator() {
        return new SparseDoubleArrayIterator();
    }

    @Override
    public int length() {
        return this.maxLength;
    }

    @Override
    public void set(int n, Double d) {
        this.setPrimitive(n, d);
    }

    public void setPrimitive(int n, double d) {
        int n2 = Arrays.binarySearch(this.indices, n);
        if (d != 0.0) {
            if (n2 < 0) {
                int n3 = 0 - (n2 + 1);
                int[] nArray = Arrays.copyOf(this.indices, this.indices.length + 1);
                double[] dArray = Arrays.copyOf(this.values, this.values.length + 1);
                for (int i = n3; i < this.values.length; ++i) {
                    dArray[i + 1] = this.values[i];
                    nArray[i + 1] = this.indices[i];
                }
                this.indices = nArray;
                this.values = dArray;
                n2 = n3;
                this.indices[n2] = n;
            }
            this.values[n2] = d;
        } else if (d == 0.0 && n2 >= 0) {
            int n4 = this.indices.length - 1;
            int[] nArray = new int[n4];
            double[] dArray = new double[n4];
            int n5 = 0;
            for (int i = 0; i < this.indices.length; ++i) {
                if (i == n2) continue;
                nArray[n5] = this.indices[i];
                dArray[n5] = this.values[i];
                ++n5;
            }
            this.indices = nArray;
            this.values = dArray;
        }
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        int n = 0;
        for (int i = 0; i < EArray.length; ++i) {
            int n2 = -1;
            if (n < this.indices.length && (n2 = this.indices[n]) == i) {
                EArray[i] = this.values[n];
                ++n;
                continue;
            }
            EArray[i] = 0.0;
        }
        return EArray;
    }

    public double[] toPrimitiveArray(double[] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            int n2 = -1;
            if (n < this.indices.length && (n2 = this.indices[n]) == i) {
                dArray[i] = this.values[n];
                ++n;
                continue;
            }
            dArray[i] = 0.0;
        }
        return dArray;
    }

    private class SparseDoubleArrayIterator
    implements Iterator<DoubleEntry> {
        int curIndex = 0;
        DoubleEntryImpl e = new DoubleEntryImpl(-1, -1);

        @Override
        public boolean hasNext() {
            return SparseDoubleArray.this.indices.length > this.curIndex;
        }

        @Override
        public DoubleEntry next() {
            if (SparseDoubleArray.this.indices.length <= this.curIndex) {
                throw new NoSuchElementException();
            }
            this.e.index = SparseDoubleArray.this.indices[this.curIndex];
            this.e.val = SparseDoubleArray.this.values[this.curIndex];
            ++this.curIndex;
            return this.e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class DoubleEntryImpl
        implements DoubleEntry {
            public int index;
            public double val;

            public DoubleEntryImpl(int n, int n2) {
                this.index = n;
                this.val = n2;
            }

            @Override
            public int index() {
                return this.index;
            }

            @Override
            public double value() {
                return this.val;
            }

            public String toString() {
                return "[" + this.index + "->" + this.val + "]";
            }
        }
    }
}

