/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.matrix.AbstractMatrix;
import edu.ucla.sspace.util.BiMap;
import edu.ucla.sspace.util.HashBiMap;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vectors;

public class SemanticSpaceMatrix
extends AbstractMatrix {
    private final SemanticSpace sspace;
    private final BiMap<Integer, String> rowToWord;
    private final int columns;

    public SemanticSpaceMatrix(SemanticSpace semanticSpace) {
        this.sspace = semanticSpace;
        this.rowToWord = new HashBiMap<Integer, String>();
        this.columns = semanticSpace.getVectorLength();
        for (String string : semanticSpace.getWords()) {
            this.rowToWord.put(this.rowToWord.size(), string);
        }
    }

    private boolean checkModifications() {
        return this.sspace.getWords().size() != this.rowToWord.size() || this.columns != this.sspace.getVectorLength();
    }

    public Integer getRowIndex(String string) {
        return (Integer)this.rowToWord.inverse().get(string);
    }

    @Override
    public DoubleVector getRowVector(int n) {
        if (n < 0 || n >= this.rowToWord.size()) {
            throw new IndexOutOfBoundsException("Row is out of bounds: " + n);
        }
        return Vectors.asDouble(this.sspace.getVector((String)this.rowToWord.get(n)));
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public int rows() {
        return this.rowToWord.size();
    }

    @Override
    public void set(int n, int n2, double d) {
        throw new UnsupportedOperationException("Cannot modify SemanticSpace-backed matrix");
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        throw new UnsupportedOperationException("Cannot modify SemanticSpace-backed matrix");
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        throw new UnsupportedOperationException("Cannot modify SemanticSpace-backed matrix");
    }
}

