/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.SparseArray;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntegerMap<V>
extends AbstractMap<Integer, V>
implements SparseArray<V> {
    private static final long serialVersionUID = 1L;
    int[] keyIndices;
    Object[] values;

    public IntegerMap() {
        this.keyIndices = new int[0];
        this.values = new Object[0];
    }

    public IntegerMap(Map<Integer, ? extends V> map) {
        int n;
        this.keyIndices = new int[map.size()];
        this.values = new Object[map.size()];
        Iterator<Integer> iterator = map.keySet().iterator();
        for (n = 0; n < map.size(); ++n) {
            this.keyIndices[n] = iterator.next();
        }
        Arrays.sort(this.keyIndices);
        for (n = 0; n < this.keyIndices.length; ++n) {
            Integer n2 = this.keyIndices[n];
            this.values[n] = map.get(n2);
        }
    }

    public IntegerMap(V[] VArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < VArray.length; ++n) {
            if (VArray[n] == null) continue;
            ++n2;
        }
        this.keyIndices = new int[n2];
        this.values = new Object[n2];
        n = 0;
        for (int i = 0; i < VArray.length; ++i) {
            if (VArray[i] == null) continue;
            this.keyIndices[n] = i;
            this.values[n++] = VArray[i];
        }
    }

    @Override
    public int cardinality() {
        return this.keyIndices.length;
    }

    private int checkKey(Object object) {
        if (object == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException("key must be an Integer");
        }
        return (Integer)object;
    }

    @Override
    public void clear() {
        this.keyIndices = new int[0];
        this.values = new Object[0];
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.checkKey(object);
        int n2 = Arrays.binarySearch(this.keyIndices, n);
        return n2 >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Object object2 : this.values) {
            if (object2 != object && (object2 == null || !object2.equals(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V get(Object object) {
        int n = this.checkKey(object);
        return this.get(n);
    }

    @Override
    public V get(int n) {
        int n2 = Arrays.binarySearch(this.keyIndices, n);
        return (V)(n2 >= 0 ? this.values[n2] : null);
    }

    @Override
    public int[] getElementIndices() {
        return this.keyIndices;
    }

    @Override
    public Set<Integer> keySet() {
        return new KeySet();
    }

    @Override
    public int length() {
        return Integer.MAX_VALUE;
    }

    @Override
    public V put(Integer n, V v) {
        int n2 = this.checkKey(n);
        int n3 = Arrays.binarySearch(this.keyIndices, n2);
        if (n3 >= 0) {
            Object object = this.values[n3];
            this.values[n3] = v;
            return (V)object;
        }
        int n4 = 0 - (n3 + 1);
        Object[] objectArray = Arrays.copyOf(this.values, this.values.length + 1);
        int[] nArray = Arrays.copyOf(this.keyIndices, this.values.length + 1);
        for (int i = n4; i < this.values.length; ++i) {
            objectArray[i + 1] = this.values[i];
            nArray[i + 1] = this.keyIndices[i];
        }
        objectArray[n4] = v;
        nArray[n4] = n2;
        this.values = objectArray;
        this.keyIndices = nArray;
        return null;
    }

    @Override
    public V remove(Object object) {
        int n = this.checkKey(object);
        int n2 = Arrays.binarySearch(this.keyIndices, n);
        if (n2 >= 0) {
            Object object2 = this.values[n2];
            Object[] objectArray = Arrays.copyOf(this.values, this.values.length - 1);
            int[] nArray = Arrays.copyOf(this.keyIndices, this.keyIndices.length - 1);
            for (int i = n2; i < this.values.length - 1; ++i) {
                objectArray[i] = this.values[i + 1];
                nArray[i] = this.keyIndices[i + 1];
            }
            this.values = objectArray;
            this.keyIndices = nArray;
            return (V)object2;
        }
        return null;
    }

    @Override
    public void set(int n, V v) {
        this.put(n, v);
    }

    @Override
    public int size() {
        return this.keyIndices.length;
    }

    @Override
    public <E> E[] toArray(E[] EArray) {
        for (int i = 0; i < this.keyIndices.length; ++i) {
            int n = this.keyIndices[i];
            if (n < 0) continue;
            if (n >= EArray.length) break;
            EArray[this.keyIndices[i]] = this.values[i];
        }
        return EArray;
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    private class Values
    extends AbstractCollection<V> {
        private static final long serialVersionUID = 1L;

        private Values() {
        }

        @Override
        public void clear() {
            IntegerMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return IntegerMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return IntegerMap.this.size();
        }
    }

    class KeySet
    extends AbstractSet<Integer> {
        private static final long serialVersionUID = 1L;

        @Override
        public void clear() {
            IntegerMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return IntegerMap.this.containsKey(object);
        }

        @Override
        public Iterator<Integer> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            return IntegerMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return IntegerMap.this.size();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private static final long serialVersionUID = 1L;

        EntrySet() {
        }

        @Override
        public void clear() {
            IntegerMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                Object v2 = IntegerMap.this.get(k);
                return v2 == v || v != null && v.equals(v2);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return IntegerMap.this.size();
        }
    }

    class IntEntry
    extends AbstractMap.SimpleEntry<Integer, V> {
        private static final long serialVersionUID = 1L;

        public IntEntry(int n, V v) {
            super(n, v);
        }

        @Override
        public V setValue(V v) {
            return IntegerMap.this.put((Integer)this.getKey(), v);
        }
    }

    abstract class IntMapIterator<E>
    implements Iterator<E> {
        private int next = 0;

        @Override
        public boolean hasNext() {
            return this.next < IntegerMap.this.size();
        }

        public Map.Entry<Integer, V> nextEntry() {
            if (this.next >= IntegerMap.this.size()) {
                throw new NoSuchElementException("no further elements");
            }
            int n = IntegerMap.this.keyIndices[this.next];
            Object object = IntegerMap.this.values[this.next];
            ++this.next;
            return new IntEntry(n, object);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueIterator
    extends IntMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends IntMapIterator<Integer> {
        private KeyIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends IntMapIterator<Map.Entry<Integer, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<Integer, V> next() {
            return this.nextEntry();
        }
    }
}

