/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.CombinedIterator;
import edu.ucla.sspace.util.MultiMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HashMultiMap<K, V>
implements MultiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, Set<V>> map = new HashMap<K, Set<V>>();
    private int range = 0;

    public HashMultiMap() {
    }

    public HashMultiMap(Map<? extends K, ? extends V> map) {
        this();
        this.putAll(map);
    }

    @Override
    public Map<K, Set<V>> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.range = 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        for (Set<V> set : this.map.values()) {
            if (!set.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Override
    public Set<V> get(Object object) {
        return this.map.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean put(K k, V v) {
        boolean bl;
        Set<V> set = this.map.get(k);
        if (set == null) {
            set = new HashSet<V>();
            this.map.put(k, set);
        }
        if (bl = set.add(v)) {
            ++this.range;
        }
        return bl;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(MultiMap<? extends K, ? extends V> multiMap) {
        for (Map.Entry<K, V> entry : multiMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean putMulti(K k, Collection<V> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Set<V> set = this.map.get(k);
        if (set == null) {
            set = new HashSet<V>(collection.size());
            this.map.put(k, set);
        }
        int n = set.size();
        boolean bl = set.addAll(collection);
        this.range += set.size() - n;
        return bl;
    }

    @Override
    public int range() {
        return this.range;
    }

    @Override
    public Set<V> remove(Object object) {
        Set<V> set = this.map.remove(object);
        if (set != null) {
            this.range -= set.size();
        }
        return set;
    }

    @Override
    public boolean remove(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return false;
        }
        boolean bl = set.remove(v);
        if (bl) {
            --this.range;
        }
        if (set.size() == 0) {
            this.map.remove(k);
        }
        return bl;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        Iterator<Map.Entry<K, Set<V>>> iterator = this.map.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<K, Set<V>> entry = iterator.next();
            K k = entry.getKey();
            Set<V> set = entry.getValue();
            stringBuilder.append((Object)(k == this ? "(this Map)" : k));
            stringBuilder.append("=[");
            Iterator<V> iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                V v = iterator2.next();
                stringBuilder.append((Object)(v == this ? "(this Map)" : v));
                if (!iterator2.hasNext()) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
        }
    }

    @Override
    public Collection<V> values() {
        return new ValuesView();
    }

    class EntryIterator
    implements Iterator<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        K curKey;
        Iterator<V> curValues;
        Iterator<Map.Entry<K, Set<V>>> multiMapIterator;
        Map.Entry<K, V> next;
        Map.Entry<K, V> previous;

        public EntryIterator() {
            this.multiMapIterator = HashMultiMap.this.map.entrySet().iterator();
            if (this.multiMapIterator.hasNext()) {
                Map.Entry entry = this.multiMapIterator.next();
                this.curKey = entry.getKey();
                this.curValues = entry.getValue().iterator();
                this.advance();
            }
        }

        private void advance() {
            if (this.curValues.hasNext()) {
                this.next = new MultiMapEntry(this.curKey, this.curValues.next());
            } else if (this.multiMapIterator.hasNext()) {
                Map.Entry entry = this.multiMapIterator.next();
                this.curKey = entry.getKey();
                this.curValues = entry.getValue().iterator();
                assert (this.curValues.hasNext()) : "key is mapped to no values";
                this.next = new MultiMapEntry(this.curKey, this.curValues.next());
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = this.next;
            this.previous = entry;
            this.advance();
            return entry;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException("No previous element to remove");
            }
            HashMultiMap.this.remove(this.previous.getKey(), this.previous.getValue());
            this.previous = null;
        }

        private class MultiMapEntry
        extends AbstractMap.SimpleEntry<K, V>
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public MultiMapEntry(K k, V v) {
                super(k, v);
            }

            @Override
            public V setValue(V v) {
                Set set = HashMultiMap.this.get(this.getKey());
                set.remove(this.getValue());
                set.add(v);
                return super.setValue(v);
            }
        }
    }

    class EntryView
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public void clear() {
            HashMultiMap.this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Set set = HashMultiMap.this.get(entry.getKey());
                return set.contains(entry.getValue());
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return HashMultiMap.this.range();
        }
    }

    class ValuesView
    extends AbstractCollection<V>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public void clear() {
            HashMultiMap.this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            return HashMultiMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Set set : HashMultiMap.this.map.values()) {
                arrayList.add(set.iterator());
            }
            return new CombinedIterator(arrayList);
        }

        @Override
        public int size() {
            return HashMultiMap.this.range();
        }
    }
}

