/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.BiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HashBiMap<K, V>
implements BiMap<K, V> {
    private Map<K, V> originalMap;
    private BiMap<V, K> reverseMap;

    public HashBiMap() {
        this.reverseMap = new HashBiMap<V, K>(new HashMap(), this);
    }

    public HashBiMap(Map<K, V> map) {
        this.originalMap = map;
        HashMap<V, K> hashMap = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        this.reverseMap = new HashBiMap<V, K>(hashMap, this);
    }

    private HashBiMap(Map<K, V> map, BiMap<V, K> biMap) {
        this.originalMap = map;
        this.reverseMap = biMap;
    }

    @Override
    public void clear() {
        this.originalMap.clear();
        this.reverseMap.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.originalMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.originalMap.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.originalMap.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.originalMap).equals(object);
    }

    @Override
    public V get(Object object) {
        return this.originalMap.get(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.originalMap).hashCode();
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.reverseMap;
    }

    @Override
    public boolean isEmpty() {
        return this.originalMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.originalMap.keySet();
    }

    @Override
    public V put(K k, V v) {
        this.reverseMap.put(v, k);
        return this.originalMap.put(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.originalMap.putAll(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.reverseMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public V remove(Object object) {
        V v = this.originalMap.remove(object);
        if (v != null) {
            this.reverseMap.remove(v);
        }
        return v;
    }

    @Override
    public int size() {
        return this.originalMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.originalMap.values();
    }
}

