/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.util.ArrayList;
import java.util.Collection;

public class GrowableArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;

    public GrowableArrayList() {
    }

    public GrowableArrayList(Collection<? extends E> collection) {
        super(collection);
    }

    public GrowableArrayList(int n) {
        super(n);
    }

    private void checkIndex(int n) {
        if (n >= this.size()) {
            for (int i = this.size(); i <= n; ++i) {
                super.add(null);
            }
        }
    }

    @Override
    public void add(int n, E e) {
        this.checkIndex(n);
        super.add(n, e);
    }

    @Override
    public E get(int n) {
        return n >= this.size() ? null : (E)super.get(n);
    }

    @Override
    public E remove(int n) {
        return n >= this.size() ? null : (E)super.remove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n2 >= this.size() && n < this.size()) {
            super.removeRange(n, this.size() - 1);
        }
    }

    @Override
    public E set(int n, E e) {
        this.checkIndex(n);
        return super.set(n, e);
    }
}

