/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.Generator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GeneratorMap<T>
implements Map<String, T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Generator<T> generator;
    private final Map<String, T> termToItem;
    private boolean readOnly;

    public GeneratorMap(Generator<T> generator) {
        this(generator, new ConcurrentHashMap());
    }

    public GeneratorMap(Generator<T> generator, Map<String, T> map) {
        this.termToItem = map;
        this.generator = generator;
        this.readOnly = false;
    }

    @Override
    public void clear() {
        this.termToItem.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.termToItem.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.termToItem.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.termToItem.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.termToItem).equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Object object) {
        T t = this.termToItem.get(object);
        if (t == null && !this.readOnly) {
            GeneratorMap generatorMap = this;
            synchronized (generatorMap) {
                t = this.termToItem.get(object);
                if (t == null) {
                    t = this.generator.generate();
                    this.termToItem.put((String)object, t);
                }
            }
        }
        return t;
    }

    @Override
    public int hashCode() {
        return ((Object)this.termToItem).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.termToItem.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.termToItem.keySet();
    }

    @Override
    public T put(String string, T t) {
        throw new UnsupportedOperationException("Items may not be inserted into this GeneratorMap.");
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        throw new UnsupportedOperationException("Items may not be inserted into this GeneratorMap.");
    }

    @Override
    public int size() {
        return this.termToItem.size();
    }

    @Override
    public Collection<T> values() {
        return this.termToItem.values();
    }

    @Override
    public T remove(Object object) {
        return this.termToItem.remove(object);
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }
}

