/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class DirectoryWalker
implements Iterable<File> {
    private final File baseDir;
    private final FileFilter filter;

    public DirectoryWalker(File file) {
        this(file, "");
    }

    public DirectoryWalker(File file, final String string) {
        this(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(string);
            }
        });
    }

    public DirectoryWalker(File file, FileFilter fileFilter) {
        this.baseDir = file;
        this.filter = fileFilter;
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
        if (fileFilter == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Iterator<File> iterator() {
        return new FileIterator();
    }

    private class FileIterator
    implements Iterator<File> {
        private final Queue<File> files = new ArrayDeque<File>();
        private File next;

        public FileIterator() {
            for (File file : DirectoryWalker.this.baseDir.listFiles()) {
                if (!DirectoryWalker.this.filter.accept(file) && !file.isDirectory()) continue;
                this.files.offer(file);
            }
            this.advance();
        }

        private void advance() {
            this.next = null;
            while (this.next == null && !this.files.isEmpty()) {
                File file = this.files.poll();
                if (file.isDirectory()) {
                    this.files.addAll(Arrays.asList(file.listFiles(DirectoryWalker.this.filter)));
                    continue;
                }
                if (!DirectoryWalker.this.filter.accept(file)) continue;
                this.next = file;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public File next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            File file = this.next;
            this.advance();
            return file;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

