/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Counter<T>
implements Iterable<Map.Entry<T, Integer>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<T, Integer> counts = new HashMap<T, Integer>();
    private int sum = 0;

    public Counter() {
    }

    public Counter(Collection<? extends T> collection) {
        this();
        for (T t : collection) {
            this.count(t);
        }
    }

    public int count(T t) {
        Integer n = this.counts.get(t);
        int n2 = n == null ? 1 : n + 1;
        this.counts.put(t, n2);
        ++this.sum;
        return n2;
    }

    public int count(T t, int n) {
        Integer n2 = this.counts.get(t);
        int n3 = n2 == null ? n : n2 + n;
        this.counts.put(t, n3);
        this.sum += n;
        return n3;
    }

    public boolean equals(Object object) {
        return object instanceof Counter && ((Object)((Counter)object).counts).equals(this.counts);
    }

    public int getCount(T t) {
        Integer n = this.counts.get(t);
        return n == null ? 0 : n;
    }

    public double getFrequency(T t) {
        double d = this.getCount(t);
        return this.sum == 0 ? 0.0 : d / (double)this.sum;
    }

    public int hashCode() {
        return ((Object)this.counts).hashCode();
    }

    public Set<T> items() {
        return Collections.unmodifiableSet(this.counts.keySet());
    }

    @Override
    public Iterator<Map.Entry<T, Integer>> iterator() {
        return Collections.unmodifiableSet(this.counts.entrySet()).iterator();
    }

    public T max() {
        int n = -1;
        T t = null;
        for (Map.Entry<T, Integer> entry : this.counts.entrySet()) {
            if (entry.getValue() <= n) continue;
            n = entry.getValue();
            t = entry.getKey();
        }
        return t;
    }

    public T min() {
        int n = -1;
        T t = null;
        for (Map.Entry<T, Integer> entry : this.counts.entrySet()) {
            if (entry.getValue() >= n) continue;
            n = entry.getValue();
            t = entry.getKey();
        }
        return t;
    }

    public void reset() {
        this.counts.clear();
        this.sum = 0;
    }

    public int size() {
        return this.counts.size();
    }

    public int sum() {
        return this.sum;
    }

    public String toString() {
        return this.counts.toString();
    }
}

