/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class BoundedSortedMap<K, V>
extends TreeMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int bound;

    public BoundedSortedMap(int n) {
        this(n, true);
    }

    public BoundedSortedMap(int n, boolean bl) {
        super(bl ? null : new ReverseComparator());
        this.bound = n;
    }

    @Override
    public V put(K k, V v) {
        V v2 = super.put(k, v);
        if (this.size() > this.bound) {
            this.remove(this.firstKey());
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    static final class ReverseComparator<K>
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ReverseComparator() {
        }

        @Override
        public int compare(K k, K k2) {
            return -((Comparable)k).compareTo(k2);
        }
    }
}

