/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tri;

import edu.ucla.sspace.common.Filterable;
import edu.ucla.sspace.ri.RandomIndexing;
import edu.ucla.sspace.temporal.TemporalSemanticSpace;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;

public abstract class OrderedTemporalRandomIndexing
implements TemporalSemanticSpace,
Filterable {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.tri.OrderedTemporalRandomIndexing";
    public static final String PERMUTATION_FUNCTION_PROPERTY = "edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.permutationFunction";
    public static final String USE_PERMUTATIONS_PROPERTY = "edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.usePermutations";
    public static final String USE_SPARSE_SEMANTICS_PROPERTY = "edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.sparseSemantics";
    public static final String VECTOR_LENGTH_PROPERTY = "edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.vectorLength";
    public static final String WINDOW_SIZE_PROPERTY = "edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.windowSize";
    public static final int DEFAULT_VECTOR_LENGTH = 10000;
    public static final int DEFAULT_WINDOW_SIZE = 4;
    private static final Logger LOGGER = Logger.getLogger(OrderedTemporalRandomIndexing.class.getName());
    protected final Collection<Runnable> partitionHooks = new ArrayList<Runnable>();
    protected final RandomIndexing currentSlice;
    protected Long endTime;
    protected Long startTime;

    public OrderedTemporalRandomIndexing() {
        this(System.getProperties());
    }

    public OrderedTemporalRandomIndexing(Properties properties) {
        Properties properties2 = new Properties();
        String string = null;
        string = properties.getProperty(VECTOR_LENGTH_PROPERTY);
        if (string != null) {
            properties2.put("edu.ucla.sspace.ri.RandomIndexing.vectorLength", string);
        }
        if ((string = properties.getProperty(WINDOW_SIZE_PROPERTY)) != null) {
            properties2.put("edu.ucla.sspace.ri.RandomIndexing.windowSize", string);
        }
        if ((string = properties.getProperty(USE_SPARSE_SEMANTICS_PROPERTY)) != null) {
            properties2.put("edu.ucla.sspace.ri.RandomIndexing.sparseSemantics", string);
        }
        this.currentSlice = new RandomIndexing(properties2);
    }

    public void addPartitionHook(Runnable runnable) {
        this.partitionHooks.add(runnable);
    }

    protected void clear() {
        this.currentSlice.clearSemantics();
        this.startTime = null;
        this.endTime = null;
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        this.processDocument(bufferedReader, System.currentTimeMillis());
    }

    @Override
    public void processDocument(BufferedReader bufferedReader, long l) throws IOException {
        if (this.startTime != null && this.shouldPartitionSpace(l)) {
            Iterator<Runnable> iterator = this.partitionHooks.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = iterator.next();
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    LOGGER.warning("Partition hook " + runnable + " caused the " + "following exception during its operations" + throwable + " and is being removed");
                    iterator.remove();
                }
            }
            this.clear();
        }
        if (this.startTime == null) {
            this.startTime = l;
            this.endTime = l;
        } else if (this.endTime < l) {
            l = this.endTime;
        }
        this.currentSlice.processDocument(bufferedReader);
    }

    @Override
    public void setSemanticFilter(Set<String> set) {
        this.currentSlice.setSemanticFilter(set);
    }

    protected abstract boolean shouldPartitionSpace(long var1);

    @Override
    public Long startTime() {
        return this.startTime;
    }

    @Override
    public Long endTime() {
        return this.endTime;
    }

    @Override
    public abstract String getSpaceName();

    @Override
    public SortedSet<Long> getTimeSteps(String string) {
        throw new UnsupportedOperationException("getTimeSteps is not supported");
    }

    @Override
    public Vector getVectorAfter(String string, long l) {
        throw new UnsupportedOperationException("getVectorAfter is not supported");
    }

    @Override
    public Vector getVectorBefore(String string, long l) {
        throw new UnsupportedOperationException("getVectorBefore is not supported");
    }

    @Override
    public Vector getVectorBetween(String string, long l, long l2) {
        throw new UnsupportedOperationException("getVectorBetween is not supported");
    }

    @Override
    public Vector getVector(String string) {
        return this.currentSlice.getVector(string);
    }

    @Override
    public int getVectorLength() {
        return this.currentSlice.getVectorLength();
    }

    @Override
    public Set<String> getWords() {
        return this.currentSlice.getWords();
    }

    public Map<String, TernaryVector> getWordToIndexVector() {
        return this.currentSlice.getWordToIndexVector();
    }

    @Override
    public void processSpace(Properties properties) {
    }

    public void setWordToIndexVector(Map<String, TernaryVector> map) {
        this.currentSlice.setWordToIndexVector(map);
    }
}

