/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.common.WordComparator;
import edu.ucla.sspace.util.SortedMultiMap;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimilarityListGenerator {
    public static final int DEFAULT_SIMILAR_ITEMS = 10;
    private static final Logger LOGGER = Logger.getLogger(SimilarityListGenerator.class.getName());
    private final ArgOptions argOptions = new ArgOptions();

    public SimilarityListGenerator() {
        this.addOptions();
    }

    private void addOptions() {
        this.argOptions.addOption('p', "printSimilarity", "whether to print the similarity score (default: false)", false, null, "Program Options");
        this.argOptions.addOption('s', "similarityFunction", "name of a similarity function (default: cosine)", true, "String", "Program Options");
        this.argOptions.addOption('n', "numSimilar", "the number of similar words to print (default: 10)", true, "String", "Program Options");
        this.argOptions.addOption('t', "threads", "the number of threads to use (default: #procesors)", true, "int", "Program Options");
        this.argOptions.addOption('w', "overwrite", "specifies whether to overwrite the existing output (default: true)", true, "boolean", "Program Options");
        this.argOptions.addOption('v', "verbose", "prints verbose output (default: false)", false, null, "Program Options");
    }

    private void usage() {
        System.out.println("usage: java SimilarityListGenerator [options] <sspace-file> <output-dir>\n" + this.argOptions.prettyPrint());
    }

    public static void main(String[] stringArray) {
        try {
            SimilarityListGenerator similarityListGenerator = new SimilarityListGenerator();
            if (stringArray.length == 0) {
                similarityListGenerator.usage();
                return;
            }
            similarityListGenerator.run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        this.argOptions.parseOptions(stringArray);
        if (this.argOptions.numPositionalArgs() < 2) {
            throw new IllegalArgumentException("must specify input and output");
        }
        File file = new File(this.argOptions.getPositionalArg(0));
        File file2 = new File(this.argOptions.getPositionalArg(1));
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException("output directory is not a directory: " + file2);
        }
        int n = Runtime.getRuntime().availableProcessors();
        if (this.argOptions.hasOption("threads")) {
            n = this.argOptions.getIntOption("threads");
        }
        boolean bl = true;
        if (this.argOptions.hasOption("overwrite")) {
            bl = this.argOptions.getBooleanOption("overwrite");
        }
        if (this.argOptions.hasOption('v')) {
            Logger.getLogger("edu.ucla.sspace").setLevel(Level.FINE);
        }
        boolean bl2 = this.argOptions.hasOption('p');
        String string = this.argOptions.hasOption('s') ? this.argOptions.getStringOption('s').toUpperCase() : "COSINE";
        Similarity.SimType simType = Similarity.SimType.valueOf(string);
        LOGGER.fine("using similarity measure: " + (Object)((Object)simType));
        int n2 = this.argOptions.hasOption('n') ? this.argOptions.getIntOption('n') : 10;
        LOGGER.fine("loading .sspace file: " + file.getName());
        SemanticSpace semanticSpace = SemanticSpaceIO.load(file);
        File file3 = bl ? new File(file2, file.getName() + ".similarityList") : File.createTempFile(file.getName(), "similarityList", file2);
        PrintWriter printWriter = new PrintWriter(file3);
        Set<String> set = semanticSpace.getWords();
        WordComparator wordComparator = new WordComparator(n);
        for (String string2 : set) {
            SortedMultiMap<Double, String> sortedMultiMap = wordComparator.getMostSimilar(string2, semanticSpace, n2, simType);
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append(string2).append("|");
            for (Map.Entry entry : sortedMultiMap.entrySet()) {
                String string3 = (String)entry.getValue();
                Double d = (Double)entry.getKey();
                stringBuilder.append(string3);
                if (bl2) {
                    stringBuilder.append(" ").append(d);
                }
                stringBuilder.append("|");
            }
            printWriter.println(stringBuilder.toString());
            printWriter.flush();
        }
    }
}

