/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.DimensionallyInterpretableSemanticSpace;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.common.WordComparator;
import edu.ucla.sspace.text.WordIterator;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.VectorIO;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SemanticSpaceExplorer {
    private static final Map<String, Command> abbreviatedCommands = new HashMap<String, Command>();
    private final WordComparator wordComparator = new WordComparator();
    private final Map<String, SemanticSpace> fileNameToSSpace = new LinkedHashMap<String, SemanticSpace>();
    private final Map<String, String> aliasToFileName = new HashMap<String, String>();
    private SemanticSpace current = null;

    private SemanticSpaceExplorer() {
    }

    private String getCurrentSSpaceFileName() {
        for (Map.Entry<String, SemanticSpace> entry : this.fileNameToSSpace.entrySet()) {
            if (entry.getValue() != this.current) continue;
            return entry.getKey();
        }
        return null;
    }

    private SemanticSpace getSSpace(String string) {
        String string2 = this.aliasToFileName.get(string);
        return string2 != null ? this.fileNameToSSpace.get(string2) : this.fileNameToSSpace.get(string);
    }

    public boolean execute(Iterator<String> iterator) {
        return this.execute(iterator, System.out);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean execute(Iterator<String> var1_1, PrintStream var2_2) {
        block78: {
            if (!var1_1.hasNext()) {
                return false;
            }
            var3_3 = var1_1.next();
            var4_4 = null;
            try {
                var4_4 = Command.valueOf(var3_3.replaceAll("-", "_").toUpperCase());
            }
            catch (IllegalArgumentException var5_5) {
                var4_4 = SemanticSpaceExplorer.abbreviatedCommands.get(var3_3);
                if (var4_4 != null) break block78;
                var2_2.println("Unknown command: " + var3_3);
                return false;
            }
        }
        switch (1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[var4_4.ordinal()]) {
            case 1: {
                if (!var1_1.hasNext()) {
                    var2_2.println("missing .sspace file argument");
                    return false;
                }
                var5_6 = var1_1.next();
                if (this.fileNameToSSpace.containsKey(var5_6)) break;
                var6_19 = null;
                try {
                    var6_19 = SemanticSpaceIO.load(var5_6);
                }
                catch (Throwable var7_32) {
                    var2_2.println("an error occurred while loading the semantic space from " + var5_6 + ":\n" + var7_32);
                    var7_32.printStackTrace();
                }
                this.fileNameToSSpace.put(var5_6, var6_19);
                this.current = var6_19;
                break;
            }
            case 2: {
                if (!var1_1.hasNext()) {
                    var2_2.println("missing .sspace file argument");
                    return false;
                }
                var5_7 = var1_1.next();
                var6_20 = this.aliasToFileName.get(var5_7);
                var7_33 = null;
                if (var6_20 != null) {
                    this.aliasToFileName.remove(var5_7);
                    var7_33 = this.fileNameToSSpace.remove(var6_20);
                } else {
                    var7_33 = this.fileNameToSSpace.remove(var5_7);
                    var8_42 = this.aliasToFileName.entrySet().iterator();
                    while (var8_42.hasNext()) {
                        var9_50 = var8_42.next();
                        if (!var9_50.getValue().equals(var5_7)) continue;
                        var8_42.remove();
                        break;
                    }
                }
                if (var7_33 != this.current) break;
                var8_42 = this.fileNameToSSpace.values().iterator();
                this.current = var8_42.hasNext() != false ? (SemanticSpace)var8_42.next() : null;
                break;
            }
            case 3: {
                if (!var1_1.hasNext()) {
                    var2_2.println("missing .sspace file argument");
                    return false;
                }
                var5_8 = var1_1.next();
                if (!this.fileNameToSSpace.containsKey(var5_8)) {
                    var2_2.println(var5_8 + "is not currently loaded");
                    return false;
                }
                if (!var1_1.hasNext()) {
                    var2_2.println("missing alias name");
                    return false;
                }
                var6_21 = var1_1.next();
                this.aliasToFileName.put(var6_21, var5_8);
                break;
            }
            case 4: {
                if (!var1_1.hasNext()) {
                    var2_2.println("missing word argument");
                    return false;
                }
                var5_9 = var1_1.next();
                var6_22 = 10;
                if (var1_1.hasNext()) {
                    var7_34 /* !! */  = var1_1.next();
                    try {
                        var6_22 = Integer.parseInt((String)var7_34 /* !! */ );
                    }
                    catch (NumberFormatException var8_43) {
                        var2_2.println("invalid number of neighbors: " + (String)var7_34 /* !! */ );
                        return false;
                    }
                }
                var7_34 /* !! */  = Similarity.SimType.COSINE;
                if (!var1_1.hasNext()) ** GOTO lbl98
                var8_44 = var1_1.next().toUpperCase();
                try {
                    var7_34 /* !! */  = Similarity.SimType.valueOf((String)var8_44);
                }
                catch (IllegalArgumentException var9_51) {
                    for (Similarity.SimType var13_68 : Similarity.SimType.values()) {
                        if (!var13_68.name().startsWith((String)var8_44)) continue;
                        var7_34 /* !! */  = var13_68;
                    }
                    if (var7_34 /* !! */  != null) ** GOTO lbl98
                    var2_2.println("invalid similarity measure: " + (String)var8_44);
                    return false;
                }
lbl98:
                // 3 sources

                if ((var8_44 = this.wordComparator.getMostSimilar(var5_9, this.current, var6_22, var7_34 /* !! */ )) == null) {
                    var2_2.println(var5_9 + " is not in the current semantic space");
                    break;
                }
                for (Object var10_57 : var8_44.entrySet()) {
                    var2_2.println((String)var10_57.getValue() + "\t" + var10_57.getKey());
                }
                break;
            }
            case 5: {
                if (this.current == null) {
                    var2_2.println("no current semantic space");
                    return false;
                }
                if (!var1_1.hasNext()) {
                    var2_2.println("missing word argument");
                    return false;
                }
                var5_10 = var1_1.next();
                if (!var1_1.hasNext()) {
                    var2_2.println("missing word argument");
                    return false;
                }
                var6_23 = var1_1.next();
                var7_35 = Similarity.SimType.COSINE;
                if (!var1_1.hasNext()) ** GOTO lbl131
                var8_45 = var1_1.next().toUpperCase();
                try {
                    var7_35 = Similarity.SimType.valueOf((String)var8_45);
                }
                catch (IllegalArgumentException var9_53) {
                    for (Similarity.SimType var13_69 : Similarity.SimType.values()) {
                        if (!var13_69.name().startsWith((String)var8_45)) continue;
                        var7_35 = var13_69;
                    }
                    if (var7_35 != null) ** GOTO lbl131
                    var2_2.println("invalid similarity measure: " + (String)var8_45);
                    return false;
                }
lbl131:
                // 3 sources

                if ((var8_45 = this.current.getVector(var5_10)) == null) {
                    var2_2.println(var5_10 + " is not in semantic space " + this.getCurrentSSpaceFileName());
                    break;
                }
                var9_54 = this.current.getVector(var6_23);
                if (var9_54 == null) {
                    var2_2.println(var6_23 + " is not in semantic space " + this.getCurrentSSpaceFileName());
                    break;
                }
                var10_59 = Similarity.getSimilarity(var7_35, var8_45, var9_54);
                var2_2.println(var10_59);
                break;
            }
            case 6: {
                if (!var1_1.hasNext()) {
                    var2_2.println("missing word argument");
                    return false;
                }
                var5_11 = var1_1.next();
                if (!var1_1.hasNext()) {
                    var2_2.println("missing sspace argument");
                    return false;
                }
                var6_24 = var1_1.next();
                var7_36 = this.getSSpace(var6_24);
                if (var7_36 == null) {
                    var2_2.println("no such semantic space: " + var6_24);
                    return false;
                }
                if (!var1_1.hasNext()) {
                    var2_2.println("missing sspace argument");
                    return false;
                }
                var8_46 = var1_1.next();
                var9_55 = this.getSSpace(var8_46);
                if (var9_55 == null) {
                    var2_2.println("no such semantic space: " + var8_46);
                    return false;
                }
                var10_60 = Similarity.SimType.COSINE;
                if (var1_1.hasNext()) {
                    var11_63 = var1_1.next();
                    try {
                        var10_60 = Similarity.SimType.valueOf((String)var11_63);
                    }
                    catch (IllegalArgumentException var12_66) {
                        var2_2.println("invalid similarity measure: " + (String)var11_63);
                        return false;
                    }
                }
                if ((var11_63 = var7_36.getVector(var5_11)) == null) {
                    var2_2.println(var5_11 + " is not in semantic space " + var6_24);
                    break;
                }
                var12_67 = var9_55.getVector(var5_11);
                if (var12_67 == null) {
                    var2_2.println(var5_11 + " is not in semantic space " + var8_46);
                    break;
                }
                if (var11_63.length() != var12_67.length()) {
                    var2_2.println(var6_24 + " and " + var8_46 + " have different numbers " + "of dimensions and are not comparable.");
                    break;
                }
                var13_70 = Similarity.getSimilarity(var10_60, var11_63, var12_67);
                var2_2.println(var13_70);
                break;
            }
            case 7: {
                var2_2.println("available commands:\n" + SemanticSpaceExplorer.getCommands());
                break;
            }
            case 8: {
                if (!var1_1.hasNext()) {
                    var2_2.println("missing file destination argument");
                    return false;
                }
                var5_12 = var1_1.next();
                try {
                    var6_25 = new PrintStream(var5_12);
                    this.execute(var1_1, var6_25);
                    var6_25.close();
                }
                catch (IOException var6_26) {
                    var2_2.println("An error occurred while writing to " + var5_12 + ":\n" + var6_26);
                }
                break;
            }
            case 9: {
                if (this.current == null) {
                    var2_2.println("no current semantic space");
                    return false;
                }
                if (!var1_1.hasNext()) {
                    var2_2.println("missing word argument");
                    return false;
                }
                var5_13 = var1_1.next();
                var6_27 = this.current.getVector(var5_13);
                if (var6_27 == null) {
                    var2_2.println(var5_13 + " is not in semantic space " + this.getCurrentSSpaceFileName());
                    break;
                }
                var2_2.println(VectorIO.toString(var6_27));
                break;
            }
            case 10: {
                if (!var1_1.hasNext()) {
                    var2_2.println("missing .sspace file argument");
                    return false;
                }
                var5_14 = var1_1.next();
                var6_28 = this.aliasToFileName.get(var5_14);
                if (var6_28 == null) {
                    var6_28 = var5_14;
                }
                if ((var7_37 = this.fileNameToSSpace.get(var6_28)) == null) {
                    var2_2.println("no such .sspace (file is not currently loaded)");
                    return false;
                }
                this.current = var7_37;
                break;
            }
            case 11: {
                var5_15 = this.getCurrentSSpaceFileName();
                if (var5_15 != null) {
                    var2_2.println(var5_15);
                    break;
                }
                var2_2.println("none");
                break;
            }
            case 12: {
                var5_16 = null;
                if (var1_1.hasNext()) {
                    var5_16 = var1_1.next();
                }
                var6_29 = this.current.getWords();
                for (String var8_47 : var6_29) {
                    if (var5_16 == null) {
                        var2_2.println(var8_47);
                        continue;
                    }
                    if (!var8_47.startsWith(var5_16)) continue;
                    var2_2.println(var8_47);
                }
                break;
            }
            case 13: {
                if (this.current instanceof DimensionallyInterpretableSemanticSpace) {
                    if (!var1_1.hasNext()) {
                        var2_2.println("Must supply a dimension number");
                        break;
                    }
                    var5_17 = -1;
                    var6_30 = var1_1.next();
                    try {
                        var5_17 = Integer.parseInt(var6_30);
                    }
                    catch (NumberFormatException var7_39) {
                        var2_2.println("Invalid dimension: " + var6_30);
                        break;
                    }
                    var7_40 = (DimensionallyInterpretableSemanticSpace)this.current;
                    try {
                        var2_2.println(var7_40.getDimensionDescription(var5_17).toString());
                    }
                    catch (Exception var8_48) {
                        var2_2.println(var8_48.getMessage());
                    }
                    break;
                }
                var2_2.println("Current space has no dimension descriptions");
                break;
            }
            case 14: {
                if (this.current == null) {
                    var2_2.println("no .sspace loaded");
                    break;
                }
                var5_18 = this.current.getSpaceName();
                var6_31 = this.current instanceof DimensionallyInterpretableSemanticSpace;
                var7_41 = this.current.getVectorLength();
                var8_49 = this.current.getWords().size();
                var9_56 = this.current.getWords().isEmpty() != false || this.current.getVector(this.current.getWords().iterator().next()) instanceof SparseVector != false;
                var2_2.println(var5_18 + ": " + var8_49 + " words, " + var7_41 + " dimensions" + (var6_31 != false ? " with descriptions" : "") + (var9_56 != false ? ", sparse vectors" : ", dense vectors"));
                break;
            }
            default: {
                if (!SemanticSpaceExplorer.$assertionsDisabled) {
                    throw new AssertionError((Object)var4_4);
                }
                break;
            }
        }
        return true;
    }

    private static String getCommands() {
        return "  load file1.sspace [file2.sspace...]\n  unload file1.sspace [file2.sspace...]\n  get-neighbors word [number (default 10)] [similarity measure]\n  get-similarity word1 word2 [similarity measure (default cosine)]\n  compare-sspace-vectors word sspace1 sspace2 [similarity measure (default: cosine)]\n  help\n  set-current-sspace filename.sspace\n  get-current-sspace\n  alias filename.sspace name\n  write-command-results output-file command...\n  print-vector word\n  get-words [string-prefix]\n  describe-dimension number\n  describe-semantic-space\n";
    }

    private static void usage(ArgOptions argOptions) {
        System.out.println("usage: java SemanticSpaceExplorer [options]\n\nCommand line options:\n" + argOptions.prettyPrint() + "\n\nExplorer commands:\n" + SemanticSpaceExplorer.getCommands());
    }

    public static void main(String[] stringArray) {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('h', "help", "Generates a help message and exits", false, null, "Program Options");
        argOptions.addOption('f', "executeFile", "Executes the commands in the specified file and exits", true, "FILE", "Program Options");
        argOptions.addOption('s', "saveRecord", "Saves a record of all the executed commands to the specfied file", true, "FILE", "Program Options");
        argOptions.parseOptions(stringArray);
        if (argOptions.hasOption("help")) {
            SemanticSpaceExplorer.usage(argOptions);
            return;
        }
        PrintWriter printWriter = null;
        if (argOptions.hasOption("saveRecord")) {
            try {
                printWriter = new PrintWriter(argOptions.getStringOption("saveRecord"));
            }
            catch (IOException iOException) {
                System.out.println("Unable to open file for saving commands:\n" + iOException);
            }
        }
        BufferedReader bufferedReader = null;
        if (argOptions.hasOption("executeFile")) {
            try {
                bufferedReader = new BufferedReader(new FileReader(argOptions.getStringOption("executeFile")));
            }
            catch (IOException iOException) {
                System.out.println("unable to open commands file " + argOptions.getStringOption("executeFile") + ":\n" + iOException);
                return;
            }
        } else {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        }
        boolean bl = argOptions.hasOption("executeFile");
        SemanticSpaceExplorer semanticSpaceExplorer = new SemanticSpaceExplorer();
        try {
            if (!bl) {
                System.out.print("> ");
            }
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                WordIterator wordIterator = new WordIterator(string);
                if (semanticSpaceExplorer.execute(wordIterator) && printWriter != null) {
                    printWriter.println(string);
                }
                if (bl) continue;
                System.out.print("> ");
            }
        }
        catch (IOException iOException) {
            System.out.println("An error occurred while reading in a command:\n" + iOException);
        }
        if (printWriter != null) {
            printWriter.close();
        }
    }

    static {
        for (Command command : Command.values()) {
            String[] stringArray = command.toString().split("_");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string.charAt(0));
            }
            abbreviatedCommands.put(stringBuilder.toString().toLowerCase(), command);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command;

        static {
            $SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command = new int[Command.values().length];
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.LOAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.UNLOAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.ALIAS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.GET_NEIGHBORS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.GET_SIMILARITY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.COMPARE_SSPACE_VECTORS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.HELP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.WRITE_COMMAND_RESULTS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.PRINT_VECTOR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.SET_CURRENT_SSPACE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.GET_CURRENT_SSPACE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.GET_WORDS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.DESCRIBE_DIMENSION.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$ucla$sspace$tools$SemanticSpaceExplorer$Command[Command.DESCRIBE_SEMANTIC_SPACE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum Command {
        LOAD,
        UNLOAD,
        GET_NEIGHBORS,
        GET_SIMILARITY,
        COMPARE_SSPACE_VECTORS,
        HELP,
        WRITE_COMMAND_RESULTS,
        SET_CURRENT_SSPACE,
        GET_CURRENT_SSPACE,
        PRINT_VECTOR,
        ALIAS,
        GET_WORDS,
        DESCRIBE_DIMENSION,
        DESCRIBE_SEMANTIC_SPACE;

    }
}

