/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.text.DocumentPreprocessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;

public class BlogPreProcessor {
    private static final Logger LOGGER = Logger.getLogger(BlogPreProcessor.class.getName());
    private DocumentPreprocessor processor;
    private final PrintWriter pw;
    private boolean saveTS;
    private long beginTime;
    private long endTime;

    private BlogPreProcessor(File file, File file2, long l, long l2) {
        PrintWriter printWriter = null;
        this.beginTime = l;
        this.endTime = l2;
        try {
            printWriter = new PrintWriter(file2);
            this.processor = new DocumentPreprocessor(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        this.pw = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        String string2 = null;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            if (string.contains("<id>")) {
                int n2 = string.indexOf(">") + 1;
                n = string.lastIndexOf("<");
                string3 = string.substring(n2, n);
                continue;
            }
            if (string.contains("<content>")) {
                int n3 = string.indexOf(">") + 1;
                n = string.lastIndexOf("<");
                stringBuilder = new StringBuilder();
                if (n > n3) {
                    stringBuilder.append(string.substring(n3, n));
                    continue;
                }
                stringBuilder.append(string.substring(n3));
                bl = true;
                continue;
            }
            if (bl) {
                int n4;
                int n5 = n4 = string.contains("</content>") ? string.lastIndexOf("<") : -1;
                if (n4 > 0) {
                    stringBuilder.append(string.substring(0, n4));
                    bl = false;
                    continue;
                }
                stringBuilder.append(string);
                continue;
            }
            if (string.contains("<updated>")) {
                int n6 = string.indexOf(">") + 1;
                string2 = string.substring(n6, n = string.lastIndexOf("<"));
                if (!string2.equals("")) continue;
                string2 = null;
                continue;
            }
            if (stringBuilder == null || string2 == null) continue;
            long l = Timestamp.valueOf(string2).getTime();
            if (l < this.beginTime || l > this.endTime) {
                bl = false;
                string2 = null;
                continue;
            }
            String string4 = this.processor.process(stringBuilder.toString());
            if (!string4.equals("")) {
                PrintWriter printWriter = this.pw;
                synchronized (printWriter) {
                    this.pw.format("%d %s\n", l, string4);
                    this.pw.flush();
                }
            }
            LOGGER.info(String.format("Processed blog %s with timestamp %d", string3, l));
            bl = false;
            string2 = null;
        }
        bufferedReader.close();
    }

    public static ArgOptions setupOptions() {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('d', "docFiles", "location of directory containing only blog files", true, "FILE[,FILE,...]", "Required");
        argOptions.addOption('w', "wordlist", "Word List for cleaning documents", true, "STRING", "Required");
        argOptions.addOption('s', "beginTime", "Earliest timestamp for any document", true, "INTEGER", "Optional");
        argOptions.addOption('e', "endTime", "Latest timestamp for any document", true, "INTEGER", "Optional");
        argOptions.addOption('h', "threads", "number of threads", true, "INT");
        return argOptions;
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        int n;
        ArgOptions argOptions = BlogPreProcessor.setupOptions();
        argOptions.parseOptions(stringArray);
        if (!argOptions.hasOption("docFiles") || !argOptions.hasOption("wordlist") || argOptions.numPositionalArgs() != 1) {
            System.out.println("usage: java BlogPreProcessor [options] <out_file> \n" + argOptions.prettyPrint());
            System.exit(1);
        }
        File file = new File(argOptions.getPositionalArg(0));
        File file2 = new File(argOptions.getStringOption("wordlist"));
        long l = argOptions.hasOption("beginTime") ? argOptions.getLongOption("beginTime") : 0L;
        long l2 = argOptions.hasOption("endTime") ? argOptions.getLongOption("endTime") : Long.MAX_VALUE;
        final BlogPreProcessor blogPreProcessor = new BlogPreProcessor(file2, file, l, l2);
        String[] stringArray2 = argOptions.getStringOption("docFiles").split(",");
        int n2 = Runtime.getRuntime().availableProcessors();
        if (argOptions.hasOption("threads")) {
            n2 = argOptions.getIntOption("threads");
        }
        ArrayDeque<File> arrayDeque = new ArrayDeque<File>();
        String[] object = stringArray2;
        int linkedList = object.length;
        for (n = 0; n < linkedList; ++n) {
            String string = object[n];
            arrayDeque.add(new File(string));
        }
        final Iterator iterator = arrayDeque.iterator();
        LinkedList<1> linkedList2 = new LinkedList<1>();
        for (n = 0; n < n2; ++n) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        try {
                            LOGGER.info("processing: " + file.getPath());
                            blogPreProcessor.processFile(file);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            };
            linkedList2.add(thread);
        }
        for (Thread thread : linkedList2) {
            thread.start();
        }
        for (Thread thread : linkedList2) {
            thread.join();
        }
    }
}

