/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text.corpora;

import edu.ucla.sspace.text.DirectoryCorpusReader;
import edu.ucla.sspace.text.DocumentPreprocessor;
import edu.ucla.sspace.text.TemporalDocument;
import edu.ucla.sspace.text.TemporalStringDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class TemporalUsenetCorpusReader
extends DirectoryCorpusReader<TemporalDocument> {
    private static final String END_OF_DOCUMENT = "---END.OF.DOCUMENT---";

    public TemporalUsenetCorpusReader() {
    }

    public TemporalUsenetCorpusReader(DocumentPreprocessor documentPreprocessor) {
        super(documentPreprocessor);
    }

    @Override
    protected Iterator<TemporalDocument> corpusIterator(Iterator<File> iterator) {
        return new UseNetIterator(iterator);
    }

    public class UseNetIterator
    extends DirectoryCorpusReader.BaseFileIterator {
        private BufferedReader usenetReader;
        private long curDocTimestamp;

        public UseNetIterator(Iterator<File> iterator) {
            super(iterator);
        }

        @Override
        protected void setupCurrentDoc(File file) {
            try {
                this.usenetReader = new BufferedReader(new FileReader(file));
                String[] stringArray = file.getName().split("\\.");
                String string = stringArray[stringArray.length - 2];
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)), Integer.parseInt(string.substring(6, 8)));
                this.curDocTimestamp = gregorianCalendar.getTimeInMillis();
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }

        protected TemporalDocument advanceInDoc() {
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                while ((string = this.usenetReader.readLine()) != null) {
                    if (string.contains(TemporalUsenetCorpusReader.END_OF_DOCUMENT)) {
                        return new TemporalStringDocument(this.cleanDoc(stringBuilder.toString()), this.curDocTimestamp);
                    }
                    int n = 0;
                    char c = string.charAt(n);
                    while (n < string.length() && (c == '>' || c == ' ')) {
                        c = string.charAt(++n);
                    }
                    stringBuilder.append(string.substring(n)).append(" ");
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            return null;
        }
    }
}

