/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text.corpora;

import edu.ucla.sspace.text.CorpusReader;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.StringDocument;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SenseEvalDependencyCorpusReader
implements CorpusReader<Document> {
    @Override
    public Iterator<Document> read(File file) {
        try {
            return this.read(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOError(fileNotFoundException);
        }
    }

    @Override
    public Iterator<Document> read(Reader reader) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.parse(new InputSource(reader));
            return new SenseEvalIterator(document.getElementsByTagName("instance"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return null;
    }

    public class SenseEvalIterator
    implements Iterator<Document> {
        private NodeList instances;
        private int currentNodeIndex;
        private String currentDoc;

        public SenseEvalIterator(NodeList nodeList) {
            this.instances = nodeList;
            this.currentDoc = null;
            this.currentNodeIndex = 0;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.currentDoc != null;
        }

        @Override
        public synchronized Document next() {
            StringDocument stringDocument = new StringDocument(this.currentDoc);
            this.currentDoc = this.advance();
            return stringDocument;
        }

        @Override
        public synchronized void remove() {
            throw new UnsupportedOperationException("Remove not permitted.");
        }

        protected String advance() {
            if (this.currentNodeIndex >= this.instances.getLength()) {
                return null;
            }
            Element element = (Element)this.instances.item(this.currentNodeIndex++);
            String string = element.getAttribute("id");
            String string2 = element.getAttribute("name");
            String string3 = element.getFirstChild().getNodeValue();
            return String.format("%s\n%s\n%s", string, string2, string3);
        }
    }
}

