/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text.corpora;

import edu.ucla.sspace.text.CorpusReader;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.StringDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class PukWacCorpusReader
implements CorpusReader<Document> {
    @Override
    public Iterator<Document> read(File file) {
        try {
            return this.read(new FileReader(file));
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public Iterator<Document> read(Reader reader) {
        return new UkWacIterator(new BufferedReader(reader));
    }

    public class UkWacIterator
    implements Iterator<Document> {
        protected BufferedReader reader;
        private String next;

        public UkWacIterator(BufferedReader bufferedReader) {
            this.reader = bufferedReader;
            this.next = this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Document next() {
            StringDocument stringDocument = new StringDocument(this.next);
            this.next = this.advance();
            return stringDocument;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove documents from a CorpusReader");
        }

        protected String advance() {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                String string = null;
                while ((string = this.reader.readLine()) != null) {
                    if (string.startsWith("<text") || string.startsWith("<s>") || string.startsWith("</s>") || string.length() == 0) continue;
                    if (!string.startsWith("</text>")) {
                        String[] stringArray = string.split("\\s+");
                        stringBuilder.append(stringArray[0]).append(" ");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            if (stringBuilder.length() == 0) {
                return null;
            }
            return stringBuilder.toString();
        }
    }
}

