/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.StringDocument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;

public class UkWacDependencyFileIterator
implements Iterator<Document> {
    private final BufferedReader documentsReader;
    private String nextLine;

    public UkWacDependencyFileIterator(String string) throws IOException {
        this.documentsReader = new BufferedReader(new FileReader(string));
        this.nextLine = this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    private String advance() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        if (this.documentsReader.readLine() == null) {
            return null;
        }
        while ((string = this.documentsReader.readLine()) != null && !string.equals("</text>")) {
            if (string.startsWith("<s>") || string.startsWith("</s>")) continue;
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized Document next() {
        StringDocument stringDocument = new StringDocument(this.nextLine);
        try {
            this.nextLine = this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return stringDocument;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("removing documents is not supported");
    }
}

